/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.util.NestedRuntimeException;

public class TxUtils {
    private static final String[] TxStatusStrings = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};

    private TxUtils() {
    }

    public static boolean isActive(Transaction tx) {
        try {
            return tx != null && tx.getStatus() == 0;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        try {
            return TxUtils.isActive(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isActive(UserTransaction ut) {
        try {
            return ut.getStatus() == 0;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isUncommitted(Transaction tx) {
        try {
            if (tx == null) {
                return false;
            }
            int status = tx.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isUncommitted(TransactionManager tm) {
        try {
            return TxUtils.isUncommitted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isCompleted(Transaction tx) {
        try {
            if (tx == null) {
                return true;
            }
            int status = tx.getStatus();
            return status == 3 || status == 4 || status == 6;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isCompleted(TransactionManager tm) {
        try {
            return TxUtils.isCompleted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static boolean isCompleted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return status == 3 || status == 4 || status == 6;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException((Throwable)error);
        }
    }

    public static String getStatusAsString(int status) {
        if (status >= 0 && status <= 9) {
            return TxStatusStrings[status];
        }
        return "STATUS_INVALID(" + status + ")";
    }

    public static String getXAResourceFlagsAsString(int flags) {
        if (flags == 0) {
            return "|TMNOFLAGS";
        }
        StringBuffer sbuf = new StringBuffer(64);
        if ((flags & 0x40000000) != 0) {
            sbuf.append("|TMONEPHASE");
        }
        if ((flags & 0x200000) != 0) {
            sbuf.append("|TMJOIN");
        }
        if ((flags & 0x8000000) != 0) {
            sbuf.append("|TMRESUME");
        }
        if ((flags & 0x4000000) != 0) {
            sbuf.append("|TMSUCCESS");
        }
        if ((flags & 0x20000000) != 0) {
            sbuf.append("|TMFAIL");
        }
        if ((flags & 0x2000000) != 0) {
            sbuf.append("|TMSUSPEND");
        }
        if ((flags & 0x1000000) != 0) {
            sbuf.append("|TMSTARTRSCAN");
        }
        if ((flags & 0x800000) != 0) {
            sbuf.append("|TMENDRSCAN");
        }
        return sbuf.toString();
    }

    public static String getXAErrorCodeAsString(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }
}

