/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.ClassProxyFactory;

public class VersionedObjectForwardingInterceptor
implements Interceptor {
    public String getName() {
        return "VersionedObjectForwardingInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object target = invocation.getTargetObject();
        if (target instanceof Advised) {
            ClassAdvisor advisor = (ClassAdvisor)((Advised)target)._getAdvisor();
            return advisor.invoke(invocation);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long methodHash = methodInvocation.getMethodHash();
            HashMap methodMap = ClassProxyFactory.getMethodMap(target.getClass());
            Method method = (Method)methodMap.get(new Long(methodHash));
            Object[] args = methodInvocation.getArguments();
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        throw new RuntimeException("should only be METHOD invocations on a non-advised target object: " + invocation.getClass().getName());
    }
}

