/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;

public class KernelAspectFactory
implements AspectFactory {
    private Kernel kernel;
    private String name;
    private AspectFactory factory;

    public KernelAspectFactory(Kernel kernel, String name) {
        this.kernel = kernel;
        this.name = name;
    }

    public Object createPerVM() {
        return this.getFactory().createPerVM();
    }

    public Object createPerClass(Advisor advisor) {
        return this.getFactory().createPerClass(advisor);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        return this.getFactory().createPerInstance(advisor, instanceAdvisor);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        return this.getFactory().createPerJoinpoint(advisor, jp);
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        return this.getFactory().createPerJoinpoint(advisor, instanceAdvisor, jp);
    }

    public AspectFactory getFactory() {
        if (this.factory == null) {
            ControllerContext context = this.kernel.getController().getInstalledContext((Object)this.name);
            if (context == null) {
                throw new IllegalStateException(this.name + " is not installed");
            }
            this.factory = (AspectFactory)context.getTarget();
        }
        return this.factory;
    }

    public String getName() {
        return this.name;
    }
}

