/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;

public class GenericKernelAspectFactory
implements AspectFactory {
    private Kernel kernel;
    private String name;
    private GenericBeanFactory factory;

    public GenericKernelAspectFactory(Kernel kernel, String name) {
        this.kernel = kernel;
        this.name = name;
    }

    public GenericBeanFactory getFactory() {
        if (this.factory == null) {
            ControllerContext context = this.kernel.getController().getInstalledContext((Object)this.name);
            if (context == null) {
                throw new IllegalStateException(this.name + " is not installed");
            }
            this.factory = (GenericBeanFactory)context.getTarget();
        }
        return this.factory;
    }

    public Object createIt() {
        try {
            return this.getFactory().createBean();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public Object createPerVM() {
        return this.createIt();
    }

    public Object createPerClass(Advisor advisor) {
        return this.createIt();
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        return this.createIt();
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        return this.createIt();
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        return this.createIt();
    }

    public String getName() {
        return this.name;
    }
}

