/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;

public class DelegatingAspectFactory
implements AspectFactory {
    private String className;
    private AspectFactory factory;
    private String name;

    public DelegatingAspectFactory(String className, String name) {
        this.className = className;
        this.name = name;
    }

    protected AspectFactory getFactory() {
        if (this.factory == null) {
            try {
                this.factory = (AspectFactory)Thread.currentThread().getContextClassLoader().loadClass(this.className).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.factory;
    }

    public Object createPerVM() {
        return this.getFactory().createPerVM();
    }

    public Object createPerClass(Advisor advisor) {
        return this.getFactory().createPerClass(advisor);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        return this.getFactory().createPerInstance(advisor, instanceAdvisor);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        return this.getFactory().createPerJoinpoint(advisor, jp);
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        return this.getFactory().createPerJoinpoint(advisor, instanceAdvisor, jp);
    }

    public String getName() {
        return this.name;
    }
}

