/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.prototype.introductions.jmx;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.beans.metadata.spi.AnnotationAttributeMetaData;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

public class JMXIntroduction
implements Interceptor {
    public String getName() {
        return this.getClass().getName();
    }

    protected Object getAnnotation(KernelControllerContext context, String name) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set annotations = metaData.getAnnotations();
        if (annotations != null && annotations.size() > 0) {
            Iterator i = annotations.iterator();
            while (i.hasNext()) {
                AnnotationMetaData a = (AnnotationMetaData)i.next();
                if (!name.equals(a.getName())) continue;
                return a;
            }
        }
        return null;
    }

    protected String getAttribute(Object a, String name) {
        AnnotationMetaData annotation = (AnnotationMetaData)a;
        Set attributes = annotation.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                AnnotationAttributeMetaData attribute = (AnnotationAttributeMetaData)i.next();
                if (!name.equals(attribute.getName())) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        String jmxName;
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        Object annotation = this.getAnnotation(context, "org.jboss.annotation.JMX");
        String name = (String)context.getName();
        ObjectName objectName = new ObjectName("test:name='" + name + "'");
        if (annotation != null && (jmxName = this.getAttribute(annotation, "name")) != null) {
            objectName = new ObjectName(jmxName);
        }
        ControllerContext mbc = context.getController().getInstalledContext((Object)"MBeanServer");
        MBeanServer server = (MBeanServer)mbc.getTarget();
        if ("setKernelControllerContext".equals(mi.getMethod().getName())) {
            String intf;
            Class<?> intfClass = null;
            if (annotation != null && (intf = this.getAttribute(annotation, "interface")) != null) {
                intfClass = Thread.currentThread().getContextClassLoader().loadClass(intf);
            }
            StandardMBean mbean = new StandardMBean(context.getTarget(), intfClass);
            server.registerMBean(mbean, objectName);
        } else {
            server.unregisterMBean(objectName);
        }
        return null;
    }
}

