/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.prototype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.Domain;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodJoinPoint;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.MethodHashing;
import org.jboss.util.NotImplementedException;

public class ProxyAdvisor
extends ClassContainer
implements InstanceAdvisor {
    protected Class[] interfaces;
    protected Object target;
    protected SimpleMetaData metadata;
    protected Method[] allMethods;
    protected transient WeakHashMap instanceAspects;
    protected transient WeakHashMap joinpointAspects;
    protected InvocationHandler handler = new ProxyAdvisorInvocationHandler();
    static /* synthetic */ Class class$java$lang$Object;

    public static Object createAdvisedProxy(Object target) {
        if (target == null) {
            throw new IllegalArgumentException("No target");
        }
        return ProxyAdvisor.createAdvisedProxy(target.getClass().getClassLoader(), target);
    }

    public static Object createAdvisedProxy(ClassLoader cl, Object target) {
        Class[] intfs;
        if (target == null) {
            throw new IllegalArgumentException("No target");
        }
        HashSet<Class> interfaces = new HashSet<Class>();
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            intfs = clazz.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                interfaces.add(intfs[i]);
            }
        }
        intfs = interfaces.toArray(new Class[interfaces.size()]);
        return ProxyAdvisor.createAdvisedProxy(cl, intfs, target);
    }

    public static Object createAdvisedProxy(ClassLoader cl, Class[] interfaces, Object target) {
        AspectManager manager = AspectManager.instance();
        return ProxyAdvisor.createAdvisedProxy(cl, interfaces, target, manager);
    }

    public static Object createAdvisedProxy(ClassLoader cl, Class[] interfaces, Object target, AspectManager manager) {
        return ProxyAdvisor.createAdvisedProxy(false, cl, interfaces, target, null, manager);
    }

    public static Object createAdvisedProxy(boolean advised, ClassLoader cl, Class[] interfaces, Object target, AspectManager manager) {
        return ProxyAdvisor.createAdvisedProxy(advised, cl, interfaces, target, null, manager);
    }

    public static Object createAdvisedProxy(boolean advised, ClassLoader cl, Class[] interfaces, Object target, SimpleMetaData metadata, AspectManager manager) {
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        ProxyAdvisor advisor = new ProxyAdvisor(manager, interfaces, target, metadata);
        if (advised || advisor.hasAspects()) {
            return Proxy.newProxyInstance(cl, advisor.getInterfaces(), advisor.handler);
        }
        return target;
    }

    protected ProxyAdvisor(AspectManager manager, Class[] interfaces, Object target, SimpleMetaData metadata) {
        super("ProxyAdvisor", manager);
        this.interfaces = interfaces;
        this.target = target;
        this.metadata = metadata;
        this.initializeInterfaceIntroductions(target.getClass());
        this.initializeClassContainer();
        this.initializeInstanceAspects();
        this.initializeJoinpointAspects();
    }

    public Method[] getAllMethods() {
        return this.allMethods;
    }

    protected Class[] getInterfaces() {
        return this.interfaces;
    }

    protected void createMethodMap() {
        try {
            if (this.interfaces != null) {
                for (int i = 0; i < this.interfaces.length; ++i) {
                    Class intf = this.interfaces[i];
                    Method[] declaredMethods = intf.getMethods();
                    for (int j = 0; j < declaredMethods.length; ++j) {
                        long hash = MethodHashing.methodHash((Method)declaredMethods[j]);
                        this.advisedMethods.put(hash, (Object)declaredMethods[j]);
                    }
                }
                Class[] intfs = null;
                for (int i = 0; i < this.interfaceIntroductions.size(); ++i) {
                    InterfaceIntroduction ii = (InterfaceIntroduction)this.interfaceIntroductions.get(i);
                    String[] intf = ii.getInterfaces();
                    intfs = new Class[intf.length];
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    for (int j = 0; j < intf.length; ++j) {
                        intfs[j] = cl.loadClass(intf[j]);
                        Method[] declaredMethods = intfs[j].getMethods();
                        for (int k = 0; k < declaredMethods.length; ++k) {
                            long hash = MethodHashing.methodHash((Method)declaredMethods[k]);
                            this.advisedMethods.put(hash, (Object)declaredMethods[k]);
                        }
                    }
                }
                if (intfs != null) {
                    HashSet<Class> set = new HashSet<Class>();
                    set.addAll(Arrays.asList(this.interfaces));
                    set.addAll(Arrays.asList(intfs));
                    this.interfaces = set.toArray(new Class[set.size()]);
                }
                Object[] values = this.advisedMethods.getValues();
                this.allMethods = new Method[values.length];
                System.arraycopy(values, 0, this.allMethods, 0, values.length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    protected void createConstructorTables() {
        this.constructors = new Constructor[0];
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        throw new NotImplementedException("FIXME NYI appendInterceptor");
    }

    public void appendInterceptor(Interceptor interceptor) {
        throw new NotImplementedException("FIXME NYI appendInterceptor");
    }

    public void appendInterceptorStack(String stackName) {
        throw new NotImplementedException("FIXME NYI appendInterceptorStack");
    }

    public Domain getDomain() {
        throw new RuntimeException("getDomain() is only available when you use weaving with generated advisors");
    }

    public Interceptor[] getInterceptors() {
        throw new NotImplementedException("FIXME NYI getInterceptors");
    }

    public Interceptor[] getInterceptors(Interceptor[] baseChain) {
        throw new NotImplementedException("FIXME NYI getInterceptors");
    }

    public SimpleMetaData getMetaData() {
        throw new NotImplementedException("FIXME NYI getMetaData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAspect(AspectDefinition def) {
        Object aspect = this.instanceAspects.get(def);
        if (aspect == null) {
            ProxyAdvisor proxyAdvisor = this;
            synchronized (proxyAdvisor) {
                aspect = this.instanceAspects.get(def);
                if (aspect != null) {
                    return aspect;
                }
                this.getPerInstanceAspectDefinitions().add(def);
                aspect = def.getFactory().createPerInstance(null, null);
                WeakHashMap copy = new WeakHashMap(this.instanceAspects);
                copy.put(def, aspect);
                this.instanceAspects = copy;
            }
        }
        return aspect;
    }

    public Object getPerInstanceAspect(String aspectName) {
        throw new NotImplementedException("FIXME NYI getPerInstanceAspect");
    }

    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        throw new NotImplementedException("FIXME NYI getPerInstanceJoinpointAspect");
    }

    public boolean hasInterceptors() {
        throw new NotImplementedException("FIXME NYI hasInterceptors");
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        throw new NotImplementedException("FIXME NYI insertInterceptor");
    }

    public void insertInterceptor(Interceptor interceptor) {
        throw new NotImplementedException("FIXME NYI insertInterceptor");
    }

    public void insertInterceptorStack(String stackName) {
        throw new NotImplementedException("FIXME NYI insertInterceptorStack");
    }

    public void removeInterceptor(String name) {
        throw new NotImplementedException("FIXME NYI removeInterceptor");
    }

    public void removeInterceptorStack(String name) {
        throw new NotImplementedException("FIXME NYI removeInterceptorStack");
    }

    protected synchronized void initializeInstanceAspects() {
        Set defs = this.getPerInstanceAspectDefinitions();
        if (defs.size() > 0) {
            this.instanceAspects = new WeakHashMap();
            Iterator it = defs.iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                Object aspect = def.getFactory().createPerInstance((Advisor)this, (InstanceAdvisor)this);
                this.instanceAspects.put(def, aspect);
            }
        }
    }

    private synchronized void initializeJoinpointAspects() {
        Map jpAspects = this.getPerInstanceJoinpointAspectDefinitions();
        if (jpAspects.size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            Iterator it = jpAspects.keySet().iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                ConcurrentReaderHashMap joins = new ConcurrentReaderHashMap();
                this.joinpointAspects.put(def, joins);
                Set joinpoints = (Set)jpAspects.get(def);
                Iterator jps = joinpoints.iterator();
                while (jps.hasNext()) {
                    Object joinpoint = jps.next();
                    joins.put(joinpoint, def.getFactory().createPerJoinpoint((Advisor)this, (InstanceAdvisor)this, (Joinpoint)joinpoint));
                }
            }
        }
    }

    private class ProxyAdvisorInvocationHandler
    implements InvocationHandler {
        private ProxyAdvisorInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodJoinPoint joinPoint = (MethodJoinPoint)ProxyAdvisor.this.methodInterceptors.get(hash);
            Interceptor[] interceptors = null;
            if (joinPoint != null) {
                interceptors = joinPoint.interceptors;
            } else if ((class$java$lang$Object == null ? (class$java$lang$Object = ProxyAdvisor.class$("java.lang.Object")) : class$java$lang$Object) != method.getDeclaringClass()) {
                throw new IllegalArgumentException("Unknown method " + method);
            }
            MethodInvocation mi = new MethodInvocation(interceptors, hash, method, method, null);
            mi.setTargetObject(ProxyAdvisor.this.target);
            mi.setArguments(args);
            mi.setAdvisor((Advisor)ProxyAdvisor.this);
            mi.setMetaData(ProxyAdvisor.this.metadata);
            return mi.invokeNext();
        }
    }
}

