/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;

public class ReflectToJavassist {
    public static CtClass classToJavassist(Class clazz) throws NotFoundException {
        ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
        CtClass ct = pool.get(clazz.getName());
        return ct;
    }

    public static CtField fieldToJavassist(Field field) throws NotFoundException {
        Class<?> clazz = field.getDeclaringClass();
        return ReflectToJavassist.classToJavassist(field.getDeclaringClass()).getField(field.getName());
    }

    public static CtConstructor constructorToJavassist(Constructor con) throws NotFoundException {
        Class clazz = con.getDeclaringClass();
        Class<?>[] params = con.getParameterTypes();
        String[] strParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strParams[i] = ReflectToJavassist.simpleType(params[i]);
        }
        CtClass ct = ReflectToJavassist.classToJavassist(clazz);
        CtConstructor[] methods = ct.getDeclaredConstructors();
        for (int i = 0; i < methods.length; ++i) {
            CtClass[] ctParams = methods[i].getParameterTypes();
            if (ctParams.length != params.length) continue;
            boolean found = true;
            for (int j = 0; j < ctParams.length; ++j) {
                if (ctParams[j].getName().equals(strParams[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    protected static String simpleType(Class type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }

    public static CtMethod methodToJavassist(Method method) throws NotFoundException {
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] params = method.getParameterTypes();
        String[] strParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strParams[i] = ReflectToJavassist.simpleType(params[i]);
        }
        CtClass ct = ReflectToJavassist.classToJavassist(clazz);
        while (!ct.getName().equals(clazz.getName())) {
            ct = ct.getSuperclass();
        }
        CtMethod[] methods = ct.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtClass[] ctParams;
            if (!methods[i].getName().equals(method.getName()) || (ctParams = methods[i].getParameterTypes()).length != params.length) continue;
            boolean found = true;
            for (int j = 0; j < ctParams.length; ++j) {
                if (ctParams[j].getName().equals(strParams[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }
}

