/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.CtClass;
import org.jboss.aop.standalone.Compiler;

public class TransformerCommon {
    static final URL[] NO_URLS = new URL[0];

    public static boolean isCompileTime() {
        return Compiler.loader != null;
    }

    public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass) {
        TransformerCommon.compileOrLoadClass(classForPackage, newClass, TransformerCommon.isCompileTime());
    }

    public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass, boolean compile) {
        try {
            if (compile) {
                URLClassLoader loader = Compiler.loader;
                if (loader == null) {
                    loader = new URLClassLoader(NO_URLS, Thread.currentThread().getContextClassLoader());
                }
                URL url = loader.getResource(classForPackage.getName().replace('.', '/') + ".class");
                String path = url.toString();
                path = path.substring(0, path.lastIndexOf(47) + 1);
                path = path + newClass.getSimpleName() + ".class";
                URI newUrl = new URI(path);
                File file = new File(newUrl);
                FileOutputStream fp = new FileOutputStream(file);
                fp.write(newClass.toBytecode());
                fp.close();
            } else {
                newClass.toClass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

