/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.ConByMethodJoinPoint;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class ConByMethodJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_CByM_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_CByM_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_CByM_";
    private static final Class INVOCATION_TYPE = ConstructorCalledByMethodInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public ConByMethodJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPoint info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = ConByMethodJoinPointGenerator.getJoinPointClassName(this.callingMethodHash(), this.calledClass(), this.calledConHash());
        this.joinpointFieldName = ConByMethodJoinPointGenerator.getJoinPointFieldName(this.callingMethodHash(), this.calledClass(), this.calledConHash());
    }

    private long callingMethodHash() {
        return ((ConByMethodJoinPoint)this.info).callingMethodHash;
    }

    private String calledClass() {
        return ((ConByMethodJoinPoint)this.info).calledClass.getName();
    }

    private long calledConHash() {
        return ((ConByMethodJoinPoint)this.info).calledConHash;
    }

    protected boolean isVoid() {
        return false;
    }

    protected Class getReturnType() {
        return ((ConByMethodJoinPoint)this.info).calledClass;
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Constructor ctor = ((ConByMethodJoinPoint)this.info).constructor;
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getParameterTypes(), ctor.getExceptionTypes());
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return !Modifier.isStatic(((ConByMethodJoinPoint)this.info).callingMethod.getModifiers());
    }

    protected boolean hasTargetObject() {
        return false;
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPoint newInfo) throws CannotCompileException, NotFoundException {
        super.overrideDispatchMethods(superClass, clazz, (ConByMethodJoinPoint)newInfo);
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, long callingHash, boolean hasCallingObject, CtClass callingClass, CtConstructor targetCtor, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(ConByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(callingHash, classname, calledHash));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingHash, hasCallingObject, classname, targetCtor, calledHash, ciname);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return ConByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(this.callingMethodHash(), this.calledClass(), this.calledConHash());
    }

    protected static String getJoinPointClassName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getJoinPointFieldName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getJoinPointGeneratorFieldName(long callingHash, String classname, long calledHash) {
        return GENERATOR_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        long callingHash;
        boolean hasCallingObject;
        String classname;
        CtClass targetClass;
        CtConstructor targetCtor;
        long calledHash;
        String ciname;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtClass[] params;
        CtClass constructorInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, long callingHash, boolean hasCallingObject, String classname, CtConstructor targetCtor, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingHash = callingHash;
            this.hasCallingObject = hasCallingObject;
            this.classname = classname;
            this.targetClass = instrumentor.forName(classname);
            this.targetCtor = targetCtor;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetCtor.getParameterTypes();
            this.constructorInfoClass = instrumentor.forName(CallerTransformer.CON_BY_METHOD_INFO_CLASS_NAME);
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConByMethodJoinPointGenerator.getJoinPointClassName(this.callingHash, this.targetClass.getName(), this.calledHash);
            this.jp = this.callingClass.makeNestedClass(className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass invocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(invocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.params);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructorInfoClass}, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.publicConstructor.setBody("{super($1, null, $1.interceptors); this.info = $1;}");
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            int offset = this.hasCallingObject ? 2 : 1;
            CtClass[] ctorParams = new CtClass[this.params.length + offset];
            ctorParams[0] = this.jp;
            if (this.hasCallingObject) {
                ctorParams[1] = this.callingClass;
            }
            System.arraycopy(this.params, 0, ctorParams, offset, this.params.length);
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasCallingObject) {
                body.append("   super.callingObject=$" + offset + ";");
            }
            for (int i = offset; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor.setBody(body.toString());
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtClass[] getInvokeJoinPointParams() {
            if (this.hasCallingObject) {
                CtClass[] invokeParams = null;
                invokeParams = new CtClass[this.params.length + 1];
                invokeParams[0] = this.callingClass;
                System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
                return invokeParams;
            }
            return this.params;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetClass, (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinPointParams(), (CtClass[])this.targetCtor.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.hasCallingObject || this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.targetClass, (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.targetCtor.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            StringBuffer parameters = new StringBuffer("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            parameters.append(")");
            String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + parameters + ";" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.targetClass, (String)"dispatch", (CtClass[])this.getInvokeJoinPointParams(), (CtClass[])this.targetCtor.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            int offset = this.hasCallingObject ? 1 : 0;
            StringBuffer parameters = new StringBuffer("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            parameters.append(")");
            String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + parameters + ";" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }
    }
}

