/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.InterceptorFactoryWrapper;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class GeneratedInstanceAdvisorMixin
implements InstanceAdvisor,
Serializable {
    static final long serialVersionUID = -3057976129116723527L;
    protected ArrayList insertedInterceptors = null;
    protected ArrayList appendedInterceptors = null;
    protected SimpleMetaData metadata;
    protected Object instance;
    protected transient Advised advised;
    protected transient Advisor advisor;
    public boolean hasInstanceAspects = false;
    protected transient WeakHashMap aspects;
    protected transient WeakHashMap joinpointAspects;
    private InterceptorChainObserver interceptorChainObserver;

    public GeneratedInstanceAdvisorMixin() {
    }

    public GeneratedInstanceAdvisorMixin(Object instance, GeneratedClassAdvisor genadvisor) {
        this.instance = instance;
        this.advised = (Advised)instance;
        this.advisor = genadvisor;
        this.initializeAspects();
        this.initializeJoinpointAspects();
        this.interceptorChainObserver = ((ClassAdvisor)this.advisor).getInterceptorChainObserver();
    }

    public boolean hasInterceptors() {
        return this.appendedInterceptors != null || this.insertedInterceptors != null;
    }

    protected synchronized void initializeAspects() {
        if (this.advisor == null) {
            return;
        }
        if (this.aspects != null) {
            return;
        }
        ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
        Set defs = cadvisor.getPerInstanceAspectDefinitions();
        if (defs.size() > 0) {
            this.aspects = new WeakHashMap();
            Iterator it = defs.iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                Object aspect = def.getFactory().createPerInstance(this.advisor, this);
                this.aspects.put(def, aspect);
            }
        }
    }

    private synchronized void initializeJoinpointAspects() {
        if (this.advisor == null) {
            return;
        }
        if (this.joinpointAspects != null) {
            return;
        }
        ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
        Map jpAspects = cadvisor.getPerInstanceJoinpointAspectDefinitions();
        if (jpAspects.size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            Iterator it = jpAspects.keySet().iterator();
            while (it.hasNext()) {
                AspectDefinition def = (AspectDefinition)it.next();
                ConcurrentReaderHashMap joins = new ConcurrentReaderHashMap();
                this.joinpointAspects.put(def, joins);
                Set joinpoints = (Set)jpAspects.get(def);
                Iterator jps = joinpoints.iterator();
                while (jps.hasNext()) {
                    Object joinpoint = jps.next();
                    joins.put(joinpoint, def.getFactory().createPerJoinpoint(this.advisor, this, (Joinpoint)joinpoint));
                }
            }
        }
    }

    public Object getPerInstanceAspect(String def) {
        Iterator it = this.aspects.keySet().iterator();
        while (it.hasNext()) {
            AspectDefinition d = (AspectDefinition)it.next();
            if (!d.getName().equals(def)) continue;
            return this.aspects.get(d);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAspect(AspectDefinition def) {
        if (this.aspects == null) {
            this.initializeAspects();
            return this.aspects.get(def);
        }
        Object aspect = this.aspects.get(def);
        if (aspect == null) {
            GeneratedInstanceAdvisorMixin generatedInstanceAdvisorMixin = this;
            synchronized (generatedInstanceAdvisorMixin) {
                aspect = this.aspects.get(def);
                if (aspect != null) {
                    return aspect;
                }
                if (this.advisor != null && this.advisor instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
                    cadvisor.getPerInstanceAspectDefinitions().add(def);
                    aspect = def.getFactory().createPerInstance(null, null);
                    WeakHashMap copy = new WeakHashMap(this.aspects);
                    copy.put(def, aspect);
                    this.aspects = copy;
                }
            }
        }
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        if (this.joinpointAspects == null) {
            this.initializeJoinpointAspects();
            return this.getJoinpointAspect(def, joinpoint);
        }
        Object aspect = this.getJoinpointAspect(def, joinpoint);
        if (aspect == null) {
            GeneratedInstanceAdvisorMixin generatedInstanceAdvisorMixin = this;
            synchronized (generatedInstanceAdvisorMixin) {
                aspect = this.getJoinpointAspect(def, joinpoint);
                if (aspect != null) {
                    return aspect;
                }
                if (this.advisor != null && this.advisor instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.advisor;
                    cadvisor.addPerInstanceJoinpointAspect(joinpoint, def);
                    aspect = def.getFactory().createPerJoinpoint(this.advisor, this, joinpoint);
                    WeakHashMap copy = new WeakHashMap(this.joinpointAspects);
                    Map map = (Map)copy.get(def);
                    if (map == null) {
                        map = new ConcurrentReaderHashMap();
                    }
                    map.put(joinpoint, aspect);
                    this.joinpointAspects = copy;
                }
            }
        }
        return aspect;
    }

    private Object getJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        if (this.joinpointAspects == null) {
            return null;
        }
        Map map = (Map)this.joinpointAspects.get(def);
        Object aspect = map.get(joinpoint);
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            GeneratedInstanceAdvisorMixin generatedInstanceAdvisorMixin = this;
            synchronized (generatedInstanceAdvisorMixin) {
                if (this.metadata == null) {
                    this.metadata = new SimpleMetaData();
                }
            }
        }
        return this.metadata;
    }

    public Interceptor[] getInterceptors() {
        Iterator it;
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            it = this.insertedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((InterceptorFactoryWrapper)it.next()).create(null, null));
            }
        }
        if (this.appendedInterceptors != null) {
            it = this.appendedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((InterceptorFactoryWrapper)it.next()).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public Interceptor[] getInterceptors(Interceptor[] advisorChain) {
        Iterator it;
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            it = this.insertedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((InterceptorFactoryWrapper)it.next()).create(null, null));
            }
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            it = this.appendedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((InterceptorFactoryWrapper)it.next()).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public InterceptorFactoryWrapper[] getWrappers() {
        ArrayList newlist = new ArrayList();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new InterceptorFactoryWrapper[newlist.size()]);
    }

    public InterceptorFactoryWrapper[] getWrappers(InterceptorFactoryWrapper[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<InterceptorFactoryWrapper> newlist = new ArrayList<InterceptorFactoryWrapper>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new InterceptorFactoryWrapper[newlist.size()]);
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        ArrayList<InterceptorFactoryWrapper> newList = new ArrayList<InterceptorFactoryWrapper>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void insertInterceptor(Interceptor interceptor) {
        ArrayList<InterceptorFactoryWrapper> newList = new ArrayList<InterceptorFactoryWrapper>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(Interceptor interceptor) {
        ArrayList<InterceptorFactoryWrapper> newList = new ArrayList<InterceptorFactoryWrapper>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        ArrayList<InterceptorFactoryWrapper> newList = new ArrayList<InterceptorFactoryWrapper>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void removeInterceptor(String name) {
        int interceptorsRemoved = this.internalRemoveInterceptor(name);
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    private int internalRemoveInterceptor(String name) {
        ArrayList newList;
        InterceptorFactoryWrapper interceptor;
        int i;
        int interceptorsRemoved = 0;
        if (this.insertedInterceptors != null) {
            for (i = 0; i < this.insertedInterceptors.size(); ++i) {
                interceptor = (InterceptorFactoryWrapper)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.insertedInterceptors);
                newList.remove(i);
                this.insertedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        if (this.appendedInterceptors != null) {
            for (i = 0; i < this.appendedInterceptors.size(); ++i) {
                interceptor = (InterceptorFactoryWrapper)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.appendedInterceptors);
                newList.remove(i);
                this.appendedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        this.hasInstanceAspects = this.insertedInterceptors != null && this.insertedInterceptors.size() > 0 || this.appendedInterceptors != null && this.appendedInterceptors.size() > 0;
        return interceptorsRemoved;
    }

    public final boolean hasAspects() {
        return this.hasInstanceAspects;
    }

    public void insertInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.insertInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void appendInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.appendInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void removeInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsRemoved = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            interceptorsRemoved += this.internalRemoveInterceptor(interceptor.getName());
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    public Domain getDomain() {
        throw new RuntimeException("Should be handled by generated advisors");
    }

    protected void finalize() {
        ClassLoader classLoader = this.advisor.getClazz().getClassLoader();
        if (this.interceptorChainObserver == null || !this.advisor.getManager().getRegisteredCLs().containsKey(classLoader)) {
            return;
        }
        this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
    }

    private InterceptorFactoryWrapper createWrapper(Interceptor interceptor) {
        return new InterceptorFactoryWrapper(new InstanceInterceptorFactory(interceptor), null, null);
    }

    public class InstanceInterceptorFactory
    implements InterceptorFactory {
        private Interceptor interceptor;

        private InstanceInterceptorFactory(Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
            return this.interceptor;
        }

        public String getClassName() {
            return this.interceptor.getClass().getName();
        }

        public String getAdvice() {
            return "invoke";
        }

        public AspectDefinition getAspect() {
            return null;
        }

        public String getName() {
            return this.interceptor.getName();
        }

        public boolean isDeployed() {
            return true;
        }
    }
}

