/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.DummyFormResponseWriter;
import org.apache.myfaces.renderkit.html.util.DummyFormUtils;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.renderkit.html.util.UnicodeEncoder;

public class HtmlResponseWriterImpl
extends ResponseWriter
implements DummyFormResponseWriter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl == null ? (class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl = HtmlResponseWriterImpl.class$("org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl")) : class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private boolean _writeDummyForm = false;
    private Set _dummyFormParams = null;
    private Writer _writer;
    private String _contentType;
    private String _characterEncoding;
    private String _startElementName;
    private Boolean _isScript;
    private Boolean _isStyle;
    private Boolean _isTextArea;
    private UIComponent _startElementUIComponent;
    private boolean _startTagOpen;
    private static final Set s_emptyHtmlElements = new HashSet();
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl;

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding) throws FacesException {
        this._writer = writer;
        this._contentType = contentType;
        if (this._contentType == null) {
            if (log.isInfoEnabled()) {
                log.debug((Object)"No content type given, using default content type text/html");
            }
            this._contentType = DEFAULT_CONTENT_TYPE;
        }
        this._characterEncoding = characterEncoding;
        if (this._characterEncoding == null) {
            if (log.isInfoEnabled()) {
                log.debug((Object)"No character encoding given, using default character encoding ISO-8859-1");
            }
            this._characterEncoding = DEFAULT_CHARACTER_ENCODING;
        } else {
            try {
                new String("myfaces".getBytes(), characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding: " + characterEncoding);
            }
        }
    }

    public static boolean supportsContentType(String contentType) {
        String[] supportedContentTypes = HtmlRendererUtils.getSupportedContentTypes();
        for (int i = 0; i < supportedContentTypes.length; ++i) {
            String supportedContentType = supportedContentTypes[i];
            if (supportedContentType.indexOf(contentType) == -1) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void flush() throws IOException {
        this.closeStartTagIfNecessary();
    }

    public void startDocument() {
    }

    public void endDocument() throws IOException {
        FacesContext facesContext;
        MyfacesConfig myfacesConfig;
        this.flush();
        if (this._writeDummyForm) {
            DummyFormUtils.writeDummyForm(this, this._dummyFormParams);
        }
        if ((myfacesConfig = MyfacesConfig.getCurrentInstance((facesContext = FacesContext.getCurrentInstance()).getExternalContext())).isDetectJavascript() && !JavascriptUtils.isJavascriptDetected(facesContext.getExternalContext())) {
            this.startElement("script", null);
            this.writeAttribute("type", "text/javascript", null);
            StringBuffer script = new StringBuffer();
            script.append("document.location.replace('").append(facesContext.getApplication().getViewHandler().getResourceURL(facesContext, "/_javascriptDetector_")).append("?goto=").append(facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId())).append("');");
            this.writeText(script.toString(), null);
            this.endElement("script");
        }
        if (myfacesConfig.isAutoScroll()) {
            JavascriptUtils.renderAutoScrollFunction(facesContext, this);
        }
        this._writer.flush();
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write(60);
        this._writer.write(name);
        this.resetStartedElement();
        this._startElementName = name;
        this._startElementUIComponent = uiComponent;
        this._startTagOpen = true;
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this._startTagOpen) {
            if (s_emptyHtmlElements.contains(this._startElementName.toLowerCase())) {
                this._writer.write(" />");
                this.resetStartedElement();
            } else {
                this._writer.write(62);
                if (this.isScriptOrStyle()) {
                    if (HtmlRendererUtils.isXHTMLContentType(this._contentType)) {
                        this._writer.write("<![CDATA[ \n");
                    } else {
                        this._writer.write("<!--\n");
                    }
                }
            }
            this._startTagOpen = false;
        }
    }

    private void resetStartedElement() {
        this._startElementName = null;
        this._startElementUIComponent = null;
        this._isScript = null;
        this._isStyle = null;
        this._isTextArea = null;
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        if (log.isWarnEnabled() && this._startElementName != null && !name.equals(this._startElementName) && log.isWarnEnabled()) {
            log.warn((Object)("HTML nesting warning on closing " + name + ": element " + this._startElementName + (this._startElementUIComponent == null ? "" : " rendered by component : " + RendererUtils.getPathToComponent(this._startElementUIComponent)) + " not explicitly closed"));
        }
        if (this._startTagOpen) {
            this.closeStartTagIfNecessary();
            if (this._startElementName != null) {
                this.writeEndTag(name);
            }
        } else if (s_emptyHtmlElements.contains(name.toLowerCase())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("HTML nesting warning on closing " + name + ": This element must not contain nested elements or text in HTML"));
            }
        } else {
            this.writeEndTag(name);
        }
        this.resetStartedElement();
    }

    private void writeEndTag(String name) throws IOException {
        if (this.isScriptOrStyle()) {
            if (HtmlRendererUtils.isXHTMLContentType(this._contentType)) {
                if (this.isScript()) {
                    this._writer.write("\n//]]>");
                } else {
                    this._writer.write("\n]]>");
                }
            } else if (this.isScript()) {
                this._writer.write("\n//-->");
            } else {
                this._writer.write("\n-->");
            }
        }
        this._writer.write("</");
        this._writer.write(name);
        this._writer.write(62);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this._writer.write(32);
                this._writer.write(name);
                this._writer.write("=\"");
                this._writer.write(name);
                this._writer.write(34);
            }
        } else {
            String strValue = value.toString();
            this._writer.write(32);
            this._writer.write(name);
            this._writer.write("=\"");
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
            this._writer.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        String strValue = value.toString();
        this._writer.write(32);
        this._writer.write(name);
        this._writer.write("=\"");
        if (strValue.toLowerCase().startsWith("javascript:")) {
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        } else {
            this._writer.write(strValue);
        }
        this._writer.write(34);
    }

    public void writeComment(Object value) throws IOException {
        if (value == null) {
            throw new NullPointerException("comment name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write("<!--");
        this._writer.write(value.toString());
        this._writer.write("-->");
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            throw new NullPointerException("text name must not be null");
        }
        this.closeStartTagIfNecessary();
        if (value == null) {
            return;
        }
        String strValue = value.toString();
        if (this.isScriptOrStyle()) {
            this._writer.write(UnicodeEncoder.encode(strValue, false, false));
        } else {
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf name must not be null");
        }
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        this.closeStartTagIfNecessary();
        if (this.isScriptOrStyle()) {
            String strValue = new String(cbuf, off, len);
            this._writer.write(UnicodeEncoder.encode(strValue, false, false));
        } else if (this.isTextarea()) {
            String strValue = new String(cbuf, off, len);
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        } else {
            String strValue = new String(cbuf, off, len);
            this._writer.write(HTMLEncoder.encode(strValue, true, true));
        }
    }

    private boolean isScriptOrStyle() {
        this.initializeStartedTagInfo();
        return this._isStyle != null && this._isStyle != false || this._isScript != null && this._isScript != false;
    }

    private boolean isScript() {
        this.initializeStartedTagInfo();
        return this._isScript != null && this._isScript != false;
    }

    private boolean isTextarea() {
        this.initializeStartedTagInfo();
        return this._isTextArea != null && this._isTextArea != false;
    }

    private void initializeStartedTagInfo() {
        if (this._startElementName != null) {
            if (this._isScript == null) {
                if (this._startElementName.equalsIgnoreCase("script")) {
                    this._isScript = Boolean.TRUE;
                    this._isStyle = Boolean.FALSE;
                    this._isTextArea = Boolean.FALSE;
                } else {
                    this._isScript = Boolean.FALSE;
                }
            }
            if (this._isStyle == null) {
                if (this._startElementName.equalsIgnoreCase("style")) {
                    this._isStyle = Boolean.TRUE;
                    this._isTextArea = Boolean.FALSE;
                } else {
                    this._isStyle = Boolean.FALSE;
                }
            }
            if (this._isTextArea == null) {
                this._isTextArea = this._startElementName.equalsIgnoreCase("textarea") ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        HtmlResponseWriterImpl newWriter = new HtmlResponseWriterImpl(writer, this.getContentType(), this.getCharacterEncoding());
        newWriter._writeDummyForm = this._writeDummyForm;
        newWriter._dummyFormParams = this._dummyFormParams;
        return newWriter;
    }

    public void close() throws IOException {
        this.closeStartTagIfNecessary();
        this._writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf, off, len);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        this._writer.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        if (str.length() > 0) {
            this._writer.write(UnicodeEncoder.encode(str, false, false));
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = str.substring(off, off + len);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public boolean isWriteDummyForm() {
        return this._writeDummyForm;
    }

    public void setWriteDummyForm(boolean writeDummyForm) {
        this._writeDummyForm = writeDummyForm;
    }

    public String getDummyFormName() {
        return "linkDummyForm";
    }

    public void addDummyFormParameter(String paramName) {
        if (this._dummyFormParams == null) {
            this._dummyFormParams = new HashSet();
        }
        this._dummyFormParams.add(paramName);
    }

    public Set getDummyFormParams() {
        return this._dummyFormParams;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_emptyHtmlElements.add("area");
        s_emptyHtmlElements.add("br");
        s_emptyHtmlElements.add("base");
        s_emptyHtmlElements.add("basefont");
        s_emptyHtmlElements.add("col");
        s_emptyHtmlElements.add("frame");
        s_emptyHtmlElements.add("hr");
        s_emptyHtmlElements.add("img");
        s_emptyHtmlElements.add("input");
        s_emptyHtmlElements.add("isindex");
        s_emptyHtmlElements.add("link");
        s_emptyHtmlElements.add("meta");
        s_emptyHtmlElements.add("param");
    }

    private static class ContextInformation {
        private ContextInformation() {
        }
    }
}

