/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPropertyHolder
implements PropertyHolder {
    Collection collection;
    private String path;

    public CollectionPropertyHolder(Collection collection, String path) {
        this.collection = collection;
        this.path = path;
    }

    @Override
    public String getClassName() {
        throw new AssertionFailure("Collection property holder does not have a class name");
    }

    @Override
    public Table getTable() {
        return this.collection.getCollectionTable();
    }

    @Override
    public void addProperty(Property prop) {
        throw new AssertionFailure("Cannot add property to a collection");
    }

    @Override
    public KeyValue getIdentifier() {
        throw new AssertionFailure("Identifier collection not yet managed");
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.collection.getOwner();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        return null;
    }

    @Override
    public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
        HashMap<String, Column[]> columns = new HashMap<String, Column[]>(localColumnOverride);
        return columns;
    }

    @Override
    public String getEntityName() {
        return this.collection.getOwner().getEntityName();
    }

    @Override
    public void addProperty(Property prop, Ejb3Column[] columns) {
        throw new AssertionFailure("addProperty to a join table of a collection: does it make sense?");
    }
}

