/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.MessageLayer;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SubjectSecurityProxyFactory;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.jacc.SubjectPolicyContextHandler;
import org.jboss.security.plugins.JASPISecurityManagerServiceMBean;
import org.jboss.security.plugins.JaasSecurityManagerService;
import org.jboss.security.propertyeditor.PrincipalEditor;
import org.jboss.security.propertyeditor.SecurityDomainEditor;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JASPISecurityManagerService
extends ServiceMBeanSupport
implements JASPISecurityManagerServiceMBean {
    private static final String SECURITY_MGR_PATH = "java:/jbsx";
    private static Logger log = Logger.getLogger((Class)JaasSecurityManagerService.class);
    private static String securityMgrClassName = "org.jboss.security.plugins.JASPISecurityManager";
    private static Class securityMgrClass;
    private static String callbackHandlerClassName;
    private static Class callbackHandlerClass;
    private static String securityProxyFactoryClassName;
    private static Class securityProxyFactoryClass;
    private static Hashtable securityDomainCtxMap;
    private static NameParser parser;
    private boolean serverMode = true;
    private static String defaultUnauthenticatedPrincipal;
    private static Hashtable contextIdMap;
    private static int defaultCacheTimeout;
    private static int defaultCacheResolution;

    public boolean getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean mode) {
        this.serverMode = mode;
    }

    public String getSecurityManagerClassName() {
        return securityMgrClassName;
    }

    public void setSecurityManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        ClassLoader loader;
        securityMgrClassName = className;
        if (!AuthenticationManager.class.isAssignableFrom(securityMgrClass = (loader = Thread.currentThread().getContextClassLoader()).loadClass(securityMgrClassName))) {
            throw new ClassCastException(securityMgrClass + " does not implement " + AuthenticationManager.class);
        }
    }

    public String getSecurityProxyFactoryClassName() {
        return securityProxyFactoryClassName;
    }

    public void setSecurityProxyFactoryClassName(String className) throws ClassNotFoundException {
        securityProxyFactoryClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        securityProxyFactoryClass = loader.loadClass(securityProxyFactoryClassName);
    }

    public String getCallbackHandlerClassName() {
        return callbackHandlerClassName;
    }

    public void setCallbackHandlerClassName(String className) throws ClassNotFoundException {
        callbackHandlerClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
    }

    public boolean isValid(String securityDomain, Principal principal, Object credential) {
        boolean isValid = false;
        try {
            AuthenticationManager sdc = JASPISecurityManagerService.lookupAuthenticationManager(securityDomain);
            isValid = sdc.isValid(principal, credential, null);
        }
        catch (NamingException e) {
            log.debug((Object)("isValid(" + securityDomain + ") failed"), (Throwable)e);
        }
        return isValid;
    }

    public Principal getPrincipal(String securityDomain, Principal principal) {
        throw new IllegalStateException("Unimplemented Method");
    }

    public void registerSecurityDomain(String securityDomain, SecurityDomain instance) {
        if (securityDomain != null && securityDomain.startsWith("java:/jaas")) {
            securityDomain = securityDomain.substring("java:/jaas".length() + 1);
        } else if (securityDomain != null && securityDomain.startsWith(SECURITY_MGR_PATH)) {
            securityDomain = securityDomain.substring(SECURITY_MGR_PATH.length() + 1);
        }
        log.debug((Object)("Added " + securityDomain + ", " + instance + " to map"));
        securityDomainCtxMap.put(securityDomain, instance);
    }

    public String getDefaultUnauthenticatedPrincipal() {
        return defaultUnauthenticatedPrincipal;
    }

    public void setDefaultUnauthenticatedPrincipal(String principal) {
        defaultUnauthenticatedPrincipal = principal;
    }

    public boolean isValid(Principal principal, Object credential) {
        return false;
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        return false;
    }

    public Subject getActiveSubject() {
        return null;
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
    }

    public MessageLayer getMessageLayer() {
        throw new IllegalStateException("Unsupported Operation: getMessageLayer");
    }

    public void secureResponse(AuthParam authParam, Subject source, Map sharedState) throws AuthException {
    }

    public void validateRequest(AuthParam authParam, Subject source, Subject recipient, Map sharedState) throws AuthException {
    }

    public String getSecurityDomain() {
        throw new IllegalStateException("Unimplemented method: getSecurityDomain");
    }

    public String getSecurityDomain(String contextId) {
        return (String)contextIdMap.get(contextId);
    }

    public AuthenticationManager getSecurityManager(String securityDomain) {
        AuthenticationManager aManager = null;
        try {
            aManager = JASPISecurityManagerService.lookupAuthenticationManager(securityDomain);
        }
        catch (NamingException e) {
            log.error((Object)("Look up of security manager failed::" + e.getLocalizedMessage()));
        }
        return aManager;
    }

    public void registerSecurityDomain(String theSecurityDomain, String contextId) {
        if (theSecurityDomain != null && theSecurityDomain.startsWith("java:/jaas")) {
            theSecurityDomain = theSecurityDomain.substring("java:/jaas".length() + 1);
        } else if (theSecurityDomain != null && theSecurityDomain.startsWith(SECURITY_MGR_PATH)) {
            theSecurityDomain = theSecurityDomain.substring(SECURITY_MGR_PATH.length() + 1);
        }
        if (theSecurityDomain == null) {
            theSecurityDomain = "other";
        }
        contextIdMap.put(contextId, theSecurityDomain);
    }

    public void flushAuthenticationCache(String securityDomain) {
        try {
            AuthenticationManager am = JASPISecurityManagerService.lookupAuthenticationManager(securityDomain);
            Class[] securityDomainType = new Class[]{};
            Method m = securityMgrClass.getMethod("flushAuthenticationCache", securityDomainType);
            Object[] arg = new Object[]{};
            m.invoke((Object)am, arg);
        }
        catch (Exception e2) {
            log.debug((Object)"flushAuthenticationCache failed", (Throwable)e2);
        }
    }

    public void flushAuthenticationCache(String securityDomain, Principal user) {
        try {
            AuthenticationManager am = JASPISecurityManagerService.lookupAuthenticationManager(securityDomain);
            Class[] securityDomainType = new Class[]{Principal.class};
            Method m = securityMgrClass.getMethod("flushAuthenticationCache", securityDomainType);
            Object[] arg = new Object[]{user};
            m.invoke((Object)am, arg);
        }
        catch (Exception e2) {
            log.debug((Object)"flushAuthenticationCache failed", (Throwable)e2);
        }
    }

    protected void startService() throws Exception {
        if (this.serverMode) {
            SecurityAssociation.setServer();
        }
        SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
        Set keys = PolicyContext.getHandlerKeys();
        if (keys == null || !keys.contains("javax.security.auth.Subject.container")) {
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
        }
        CallbackHandlerPolicyContextHandler chandler = new CallbackHandlerPolicyContextHandler();
        if (keys == null || !keys.contains("org.jboss.security.auth.spi.CallbackHandler")) {
            PolicyContext.registerHandler((String)"org.jboss.security.auth.spi.CallbackHandler", (PolicyContextHandler)chandler, (boolean)false);
        }
        PropertyEditorManager.registerEditor(Principal.class, PrincipalEditor.class);
        PropertyEditorManager.registerEditor(SecurityDomain.class, SecurityDomainEditor.class);
        log.debug((Object)"Registered PrincipalEditor, SecurityDomainEditor");
        log.debug((Object)("ServerMode=" + this.serverMode));
        log.debug((Object)("SecurityMgrClass=" + securityMgrClass));
        log.debug((Object)("CallbackHandlerClass=" + callbackHandlerClass));
    }

    private static AuthenticationManager lookupAuthenticationManager(String securityDomain) throws NamingException {
        AuthenticationManager securityDomainCtx = (AuthenticationManager)securityDomainCtxMap.get(securityDomain);
        if (securityDomainCtx == null) {
            securityDomainCtx = JASPISecurityManagerService.newAuthenticationManager(securityDomain);
            securityDomainCtxMap.put(securityDomain, securityDomainCtx);
            log.debug((Object)("Added " + securityDomain + ", " + securityDomainCtx + " to map"));
        }
        return securityDomainCtx;
    }

    private static AuthenticationManager newAuthenticationManager(String securityDomain) throws NamingException {
        AuthenticationManager securityMgr = null;
        try {
            Class[] parameterTypes = new Class[]{String.class, CallbackHandler.class};
            Constructor ctor = securityMgrClass.getConstructor(parameterTypes);
            CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
            Object[] args = new Object[]{securityDomain, handler};
            securityMgr = (AuthenticationManager)ctor.newInstance(args);
            log.debug((Object)("Created securityMgr=" + securityMgr));
            TimedCachePolicy cachePolicy = new TimedCachePolicy(defaultCacheTimeout, true, defaultCacheResolution);
            cachePolicy.create();
            cachePolicy.start();
            JASPISecurityManagerService.setSecurityDomainCache(securityMgr, (CachePolicy)cachePolicy);
        }
        catch (Exception e2) {
            String msg = "Failed to create sec mgr('" + securityDomain + "'), securityMgrClass=" + securityMgrClass + ", callbackHandlerClass=" + callbackHandlerClass;
            log.error((Object)msg, (Throwable)e2);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e2);
            throw ne;
        }
        return securityMgr;
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        try {
            Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
            Method m = securityMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
            Object[] setCachePolicyArgs = new Object[]{cachePolicy};
            m.invoke((Object)securityMgr, setCachePolicyArgs);
            log.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
        }
        catch (Exception e2) {
            log.debug((Object)"setCachePolicy failed", (Throwable)e2);
        }
    }

    static {
        callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
        callbackHandlerClass = SecurityAssociationHandler.class;
        securityProxyFactoryClassName = "org.jboss.security.SubjectSecurityProxyFactory";
        securityProxyFactoryClass = SubjectSecurityProxyFactory.class;
        securityDomainCtxMap = new Hashtable();
        defaultUnauthenticatedPrincipal = "Unauthenticated Principal";
        contextIdMap = new Hashtable();
        defaultCacheTimeout = 1800;
        defaultCacheResolution = 60;
    }
}

