/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.ClientAuthModule;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.MessagePolicy;
import org.jboss.security.SimplePrincipal;

public class SimpleClientAuthModule
implements ClientAuthModule {
    private SimplePrincipal principal = null;
    private Object credential = null;
    private MessageLayer messageLayer = null;
    private MessagePolicy requestPolicy = null;
    private MessagePolicy responsePolicy = null;
    private CallbackHandler handler = null;
    private Map options = null;
    private boolean mustBeTransactional = false;

    public SimpleClientAuthModule(String layerName) {
        this.messageLayer = new MessageLayer(layerName);
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        subject.getPrincipals().remove(this.principal);
        subject.getPublicCredentials().remove(this.credential);
    }

    public MessageLayer getMessageLayer() {
        return this.messageLayer;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options, boolean mustBeTransactional) throws AuthException {
        this.requestPolicy = requestPolicy;
        this.responsePolicy = responsePolicy;
        this.handler = handler;
        this.options = options;
        this.mustBeTransactional = mustBeTransactional;
    }

    public void secureRequest(AuthParam param, Subject source, Map sharedState) throws AuthException {
        source.getPrincipals().add(this.principal);
        source.getPublicCredentials().add(this.credential);
    }

    public void validateResponse(AuthParam param, Subject source, Subject recipient, Map sharedState) throws AuthException {
        Set sourceSet = source.getPrincipals(SimplePrincipal.class);
        Set recipientSet = recipient.getPrincipals(SimplePrincipal.class);
        if (sourceSet == null && recipientSet == null) {
            throw new AuthException("Principals are null");
        }
        if (sourceSet.size() != recipientSet.size()) {
            throw new AuthException("Principals size are different");
        }
    }
}

