/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view.faces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.faces.ValidatorRenderKit;
import org.apache.shale.util.Messages;
import org.apache.shale.view.ViewController;
import org.apache.shale.view.ViewControllerMapper;
import org.apache.shale.view.faces.CallbacksFactory;
import org.apache.shale.view.faces.ViewControllerCallbacks;

public class ViewViewHandler
extends ViewHandler {
    private static final Log log = LogFactory.getLog((Class)ViewViewHandler.class);
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", ViewViewHandler.class.getClassLoader());
    private ViewControllerMapper mapper = null;
    private ViewHandler original = null;
    private ViewControllerCallbacks viewControllerCallbacks = null;

    public ViewViewHandler(ViewHandler original) {
        this.original = original;
    }

    public Locale calculateLocale(FacesContext context) {
        return this.original.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.original.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot view = this.original.createView(context, viewId);
        this.setupViewController(context, view, viewId, false);
        this.setupRenderKit(context, view);
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this.original.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.original.getResourceURL(context, path);
    }

    public void renderView(FacesContext context, UIViewRoot view) throws IOException, FacesException {
        this.original.renderView(context, view);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot view = this.original.restoreView(context, viewId);
        this.setupViewController(context, view, viewId, true);
        return view;
    }

    public void writeState(FacesContext context) throws IOException {
        this.original.writeState(context);
    }

    private ViewControllerMapper getViewControllerMapper(FacesContext context) {
        if (this.mapper == null) {
            this.mapper = (ViewControllerMapper)context.getExternalContext().getApplicationMap().get("org.apache.shale.view.VIEW_MAPPER");
        }
        if (this.mapper == null) {
            this.mapper = this.getViewControllerMapperInstance(context);
            context.getExternalContext().getApplicationMap().put("org.apache.shale.view.VIEW_MAPPER", this.mapper);
        }
        return this.mapper;
    }

    private ViewControllerMapper getViewControllerMapperInstance(FacesContext context) {
        ClassLoader cl;
        String className = context.getExternalContext().getInitParameter("org.apache.shale.view.VIEW_CONTROLLER_MAPPER");
        if (className == null) {
            className = "org.apache.shale.view.impl.DefaultViewControllerMapper";
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            return (ViewControllerMapper)clazz.newInstance();
        }
        catch (ClassCastException e) {
            throw new FacesException(messages.getMessage("view.vcmCast", new Object[]{className}), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(messages.getMessage("view.vcmClass", new Object[]{className}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(messages.getMessage("view.vcmAccess", new Object[]{className}), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException(messages.getMessage("view.vcmInstantiate", new Object[]{className}), (Throwable)e);
        }
    }

    private void setupViewController(FacesContext context, UIViewRoot view, String viewId, boolean postBack) {
        ViewControllerMapper viewControllerMapper;
        if (view == null) {
            return;
        }
        if (postBack) {
            context.getExternalContext().getRequestMap().put("org.apache.shale.view.VIEW_POSTBACK", Boolean.TRUE);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setupViewController(" + viewId + "," + postBack + ")"));
        }
        if ((viewControllerMapper = this.getViewControllerMapper(context)) == null) {
            log.warn((Object)messages.getMessage("view.noViewControllerMapper"));
            return;
        }
        String viewName = viewControllerMapper.mapViewId(viewId);
        Object vc = null;
        VariableResolver vr = context.getApplication().getVariableResolver();
        try {
            vc = vr.resolveVariable(context, viewName);
            if (vc == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)messages.getMessage("view.noViewController", new Object[]{viewId, viewName}));
                }
                return;
            }
        }
        catch (EvaluationException e) {
            log.warn((Object)messages.getMessage("view.evalException", new Object[]{viewId, viewName}), (Throwable)e);
            return;
        }
        if (vc instanceof ViewController) {
            ((ViewController)vc).setPostBack(postBack);
        }
        Map map = context.getExternalContext().getRequestMap();
        map.put("org.apache.shale.view.VIEW_NAME_RENDERED", viewName);
        ArrayList<Object> list = (ArrayList<Object>)map.get("org.apache.shale.view.VIEWS_INITIALIZED");
        if (list == null) {
            list = new ArrayList<Object>();
            map.put("org.apache.shale.view.VIEWS_INITIALIZED", list);
        }
        list.add(vc);
    }

    private ViewControllerCallbacks viewControllerCallbacks(FacesContext context) {
        if (this.viewControllerCallbacks == null) {
            this.viewControllerCallbacks = (ViewControllerCallbacks)context.getExternalContext().getApplicationMap().get("org.apache.shale.view.VIEW_CALLBACKS");
            if (this.viewControllerCallbacks == null) {
                this.viewControllerCallbacks = CallbacksFactory.getInstance().getViewControllerCallbacks();
                context.getExternalContext().getApplicationMap().put("org.apache.shale.view.VIEW_CALLBACKS", this.viewControllerCallbacks);
            }
        }
        return this.viewControllerCallbacks;
    }

    private void setupRenderKit(FacesContext context, UIViewRoot view) {
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit defaultRenderKit = factory.getRenderKit(context, view.getRenderKitId());
        if (!(defaultRenderKit instanceof ValidatorRenderKit)) {
            factory.addRenderKit(view.getRenderKitId(), (RenderKit)new ValidatorRenderKit(defaultRenderKit));
        }
    }
}

