/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.renderer;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import org.apache.shale.util.Tags;
import org.apache.shale.validator.CommonsValidator;

public class ValidatorInputRenderer
extends Renderer {
    private Renderer defaultRenderer = null;
    public static final String VALIDATOR_CLIENTIDS_ATTR = "org.apache.shale.validator.clientIdSet";

    public ValidatorInputRenderer(Renderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    public String convertClientId(FacesContext context, String id) {
        return this.defaultRenderer.convertClientId(context, id);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.defaultRenderer.decode(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof EditableValueHolder && component.isRendered()) {
            String clientId;
            TreeMap validatorVars;
            Tags tagUtils = new Tags();
            EditableValueHolder editableComponent = (EditableValueHolder)component;
            TreeMap ids = (TreeMap)component.getAttributes().get(VALIDATOR_CLIENTIDS_ATTR);
            if (ids == null) {
                ids = new TreeMap();
                component.getAttributes().put(VALIDATOR_CLIENTIDS_ATTR, ids);
            }
            if ((validatorVars = (TreeMap)ids.get(clientId = component.getClientId(context))) == null) {
                validatorVars = new TreeMap();
                ids.put(clientId, validatorVars);
            }
            Validator[] validators = editableComponent.getValidators();
            for (int i = 0; i < validators.length; ++i) {
                if (!(validators[i] instanceof CommonsValidator)) continue;
                CommonsValidator validator = (CommonsValidator)validators[i];
                TreeMap localVars = (TreeMap)validatorVars.get(validator.getType());
                if (localVars == null) {
                    localVars = new TreeMap();
                    validatorVars.put(validator.getType(), localVars);
                } else {
                    localVars.clear();
                }
                Map vars = validator.getVars();
                Iterator vi = vars.entrySet().iterator();
                while (vi.hasNext()) {
                    Map.Entry e = vi.next();
                    if (e.getValue() == null || !(e.getValue() instanceof String) || !UIComponentTag.isValueReference((String)((String)e.getValue()))) continue;
                    localVars.put(e.getKey(), tagUtils.eval((String)e.getValue()));
                }
            }
        }
        this.defaultRenderer.encodeBegin(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.defaultRenderer.encodeChildren(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.defaultRenderer.encodeEnd(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return this.defaultRenderer.getConvertedValue(context, component, value);
    }

    public boolean getRendersChildren() {
        return this.defaultRenderer.getRendersChildren();
    }
}

