/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.shale.remote.RemoteContext;
import org.apache.shale.remote.ResponseWrapper;

public abstract class AbstractListCompletions
implements Command {
    protected static final String PARAMETER = "prefix";

    protected String getInnerElement() {
        return "value";
    }

    protected String getOuterElement() {
        return "values";
    }

    public boolean execute(Context context) throws Exception {
        RemoteContext rcontext = (RemoteContext)context;
        String test = this.test(rcontext);
        String[] legal = this.legal(rcontext, test);
        String[] matches = this.match(rcontext, test, legal);
        this.render(rcontext, matches);
        return true;
    }

    protected abstract String[] legal(RemoteContext var1, String var2);

    protected String[] match(RemoteContext context, String test, String[] legal) {
        if (test == null || test.length() == 0) {
            return legal;
        }
        if (legal == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        String match = test.toLowerCase();
        for (int i = 0; i < legal.length; ++i) {
            if (!legal[i].toLowerCase().startsWith(match)) continue;
            list.add(legal[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected void render(RemoteContext context, String[] matches) throws IOException {
        context.setResponseContentType("text/xml");
        context.setResponseEncoding("UTF-8");
        ResponseWrapper wrapper = new ResponseWrapper(context.getResponseWriter(), "UTF-8");
        String inner = this.getInnerElement();
        String outer = this.getOuterElement();
        wrapper.startDocument();
        wrapper.startElement(outer);
        wrapper.writeNewline();
        for (int i = 0; i < matches.length; ++i) {
            wrapper.startElement(inner);
            if (matches[i] != null) {
                wrapper.writeText(matches[i]);
            }
            wrapper.endElement(inner);
            wrapper.writeNewline();
        }
        wrapper.endElement(outer);
        wrapper.endDocument();
    }

    protected String test(RemoteContext context) {
        String[] prefixes = (String[])context.getRequestParameters().get(PARAMETER);
        if (prefixes == null) {
            prefixes = new String[]{};
        }
        return prefixes.length > 0 ? prefixes[0] : null;
    }
}

