/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.faces;

import java.io.OutputStream;
import java.io.Writer;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.shale.renderer.ValidatorCommandRenderer;
import org.apache.shale.renderer.ValidatorInputRenderer;

public class ValidatorRenderKit
extends RenderKit {
    private static final String COMMAND_FAMILY = "javax.faces.Command";
    private static final String INPUT_FAMILY = "javax.faces.Input";
    private static final String COMMAND_LINK_TYPE = "javax.faces.Link";
    private static final String COMMAND_BUTTON_TYPE = "javax.faces.Button";
    private RenderKit defaultRenderKit = null;

    public ValidatorRenderKit(RenderKit defaultRenderKit) {
        this.defaultRenderKit = defaultRenderKit;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        this.defaultRenderKit.addRenderer(componentFamily, rendererType, renderer);
    }

    public Renderer getRenderer(String componentFamily, String rendererType) {
        Renderer target = this.defaultRenderKit.getRenderer(componentFamily, rendererType);
        if (componentFamily.equals(COMMAND_FAMILY) && (rendererType.equals(COMMAND_LINK_TYPE) || rendererType.equals(COMMAND_BUTTON_TYPE))) {
            if (!(target instanceof ValidatorCommandRenderer)) {
                target = new ValidatorCommandRenderer(target);
                this.addRenderer(componentFamily, rendererType, target);
            }
        } else if (componentFamily.equals(INPUT_FAMILY) && !(target instanceof ValidatorInputRenderer)) {
            target = new ValidatorInputRenderer(target);
            this.addRenderer(componentFamily, rendererType, target);
        }
        return target;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.defaultRenderKit.getResponseStateManager();
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        return this.defaultRenderKit.createResponseWriter(writer, contentTypeList, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return this.defaultRenderKit.createResponseStream(outputStream);
    }
}

