/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.dialog.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.shale.dialog.Dialog;
import org.apache.shale.dialog.State;
import org.apache.shale.dialog.Transition;
import org.apache.shale.dialog.impl.AbstractState;

public class DialogImpl
implements Dialog {
    private String name = null;
    private String start = null;
    private Map states = new HashMap();
    private Map transitions = new HashMap();

    public String getName() {
        return this.name;
    }

    public String getStart() {
        return this.start;
    }

    public Iterator getStateIds() {
        return this.states.keySet().iterator();
    }

    public Iterator getTransitionOutcomes() {
        return this.transitions.keySet().iterator();
    }

    public State findState(String id) {
        return (State)this.states.get(id);
    }

    public Transition findTransition(String outcome) {
        return (Transition)this.transitions.get(outcome);
    }

    public String toString() {
        return "Dialog[name=" + this.name + ",start=" + this.start + "]";
    }

    public void addState(State state) throws IllegalArgumentException {
        if (this.states.containsKey(state.getName())) {
            throw new IllegalArgumentException(state.getName());
        }
        this.states.put(state.getName(), state);
        if (state instanceof AbstractState) {
            ((AbstractState)state).setDialog(this);
        }
    }

    public void addTransition(Transition transition) throws IllegalArgumentException {
        this.transitions.put(transition.getOutcome(), transition);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void removeState(State state) {
        this.states.remove(state.getName());
        if (state instanceof AbstractState) {
            ((AbstractState)state).setDialog(null);
        }
    }

    public void removeTransition(Transition transition) {
        this.transitions.remove(transition.getOutcome());
    }
}

