/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.DummyFormResponseWriter;
import org.apache.myfaces.renderkit.html.util.DummyFormUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public class HtmlButtonRendererBase
extends HtmlRenderer {
    private static final String IMAGE_BUTTON_SUFFIX_X = ".x";
    private static final String IMAGE_BUTTON_SUFFIX_Y = ".y";
    static /* synthetic */ Class class$javax$faces$component$UICommand;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UICommand == null ? (class$javax$faces$component$UICommand = HtmlButtonRendererBase.class$("javax.faces.component.UICommand")) : class$javax$faces$component$UICommand);
        if (!HtmlButtonRendererBase.isReset(uiComponent) && HtmlButtonRendererBase.isSubmitted(facesContext, uiComponent)) {
            uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
        }
    }

    private static boolean isReset(UIComponent uiComponent) {
        return "reset".equalsIgnoreCase((String)uiComponent.getAttributes().get("type"));
    }

    private static boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        return paramMap.containsKey(clientId) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_X) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_Y);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UICommand == null ? (class$javax$faces$component$UICommand = HtmlButtonRendererBase.class$("javax.faces.component.UICommand")) : class$javax$faces$component$UICommand);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String image = this.getImage(uiComponent);
        if (image != null) {
            writer.writeAttribute("type", (Object)"image", null);
            writer.writeAttribute("src", (Object)image, "image");
        } else {
            String type = this.getType(uiComponent);
            if (type == null) {
                type = "submit";
            }
            writer.writeAttribute("type", (Object)type, "type");
            Object value = this.getValue(uiComponent);
            if (value != null) {
                writer.writeAttribute("value", value, null);
            }
        }
        if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            StringBuffer onClick = this.buildOnClick(uiComponent, facesContext, writer);
            writer.writeAttribute("onclick", (Object)onClick.toString(), null);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_ONCLICK);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
    }

    protected StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, ResponseWriter writer) throws IOException {
        DummyFormResponseWriter dummyFormResponseWriter;
        String formName;
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm nestingForm = null;
        if (parent != null) {
            nestingForm = (UIForm)parent;
            formName = nestingForm.getClientId(facesContext);
            dummyFormResponseWriter = null;
        } else {
            formName = "linkDummyForm";
            dummyFormResponseWriter = DummyFormUtils.getDummyFormResponseWriter(facesContext);
            dummyFormResponseWriter.setWriteDummyForm(true);
        }
        StringBuffer onClick = new StringBuffer();
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            onClick.append(commandOnClick);
            onClick.append(';');
        }
        onClick.append(HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName)).append("();");
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
            JavascriptUtils.appendAutoScrollAssignment(onClick, formName);
        }
        String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(formName);
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter((UIComponent)nestingForm, hiddenFieldName);
        } else {
            dummyFormResponseWriter.addDummyFormParameter(hiddenFieldName);
        }
        return onClick;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    private String getImage(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getImage();
        }
        return (String)uiComponent.getAttributes().get("image");
    }

    private String getType(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getType();
        }
        return (String)uiComponent.getAttributes().get("type");
    }

    private Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)uiComponent).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

