/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.util.StringHelper;

public class Formatter {
    private static final Set BEGIN_CLAUSES = new HashSet();
    private static final Set END_CLAUSES = new HashSet();
    private static final Set LOGICAL = new HashSet();
    private static final Set QUANTIFIERS = new HashSet();
    private static final Set DML = new HashSet();
    private static final Set MISC = new HashSet();
    String indentString = "    ";
    String initial = "\n    ";
    boolean beginLine = true;
    boolean afterBeginBeforeEnd = false;
    boolean afterByOrSetOrFromOrSelect = false;
    boolean afterValues = false;
    boolean afterOn = false;
    boolean afterBetween = false;
    boolean afterInsert = false;
    int inFunction = 0;
    int parensSinceSelect = 0;
    private LinkedList parenCounts = new LinkedList();
    private LinkedList afterByOrFromOrSelects = new LinkedList();
    int indent = 1;
    StringBuffer result = new StringBuffer();
    StringTokenizer tokens;
    String lastToken;
    String token;
    String lcToken;

    public Formatter(String sql) {
        this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[], \n\r\f\t", true);
    }

    public Formatter setInitialString(String initial) {
        this.initial = initial;
        return this;
    }

    public Formatter setIndentString(String indent) {
        this.indentString = indent;
        return this;
    }

    public String format() {
        this.result.append(this.initial);
        while (this.tokens.hasMoreTokens()) {
            String t;
            this.token = this.tokens.nextToken();
            this.lcToken = this.token.toLowerCase();
            if ("'".equals(this.token)) {
                do {
                    t = this.tokens.nextToken();
                    this.token = this.token + t;
                } while (!"'".equals(t));
            } else if ("\"".equals(this.token)) {
                do {
                    t = this.tokens.nextToken();
                    this.token = this.token + t;
                } while (!"\"".equals(t));
            }
            if (this.afterByOrSetOrFromOrSelect && ",".equals(this.token)) {
                this.commaAfterByOrFromOrSelect();
            } else if (this.afterOn && ",".equals(this.token)) {
                this.commaAfterOn();
            } else if ("(".equals(this.token)) {
                this.openParen();
            } else if (")".equals(this.token)) {
                this.closeParen();
            } else if (BEGIN_CLAUSES.contains(this.lcToken)) {
                this.beginNewClause();
            } else if (END_CLAUSES.contains(this.lcToken)) {
                this.endNewClause();
            } else if ("select".equals(this.lcToken)) {
                this.select();
            } else if (DML.contains(this.lcToken)) {
                this.updateOrInsertOrDelete();
            } else if ("values".equals(this.lcToken)) {
                this.values();
            } else if ("on".equals(this.lcToken)) {
                this.on();
            } else if (this.afterBetween && this.lcToken.equals("and")) {
                this.misc();
                this.afterBetween = false;
            } else if (LOGICAL.contains(this.lcToken)) {
                this.logical();
            } else if (Formatter.isWhitespace(this.token)) {
                this.white();
            } else {
                this.misc();
            }
            if (Formatter.isWhitespace(this.token)) continue;
            this.lastToken = this.lcToken;
        }
        return this.result.toString();
    }

    private void commaAfterOn() {
        this.out();
        --this.indent;
        this.newline();
        this.afterOn = false;
        this.afterByOrSetOrFromOrSelect = true;
    }

    private void commaAfterByOrFromOrSelect() {
        this.out();
        this.newline();
    }

    private void logical() {
        if ("end".equals(this.lcToken)) {
            --this.indent;
        }
        this.newline();
        this.out();
        this.beginLine = false;
    }

    private void on() {
        ++this.indent;
        this.afterOn = true;
        this.newline();
        this.out();
        this.beginLine = false;
    }

    private void misc() {
        this.out();
        if ("between".equals(this.lcToken)) {
            this.afterBetween = true;
        }
        if (this.afterInsert) {
            this.newline();
            this.afterInsert = false;
        } else {
            this.beginLine = false;
            if ("case".equals(this.lcToken)) {
                ++this.indent;
            }
        }
    }

    private void white() {
        if (!this.beginLine) {
            this.result.append(" ");
        }
    }

    private void updateOrInsertOrDelete() {
        this.out();
        ++this.indent;
        this.beginLine = false;
        if ("update".equals(this.lcToken)) {
            this.newline();
        }
        if ("insert".equals(this.lcToken)) {
            this.afterInsert = true;
        }
    }

    private void select() {
        this.out();
        ++this.indent;
        this.newline();
        this.parenCounts.addLast(new Integer(this.parensSinceSelect));
        this.afterByOrFromOrSelects.addLast(new Boolean(this.afterByOrSetOrFromOrSelect));
        this.parensSinceSelect = 0;
        this.afterByOrSetOrFromOrSelect = true;
    }

    private void out() {
        this.result.append(this.token);
    }

    private void endNewClause() {
        if (!this.afterBeginBeforeEnd) {
            --this.indent;
            if (this.afterOn) {
                --this.indent;
                this.afterOn = false;
            }
            this.newline();
        }
        this.out();
        if (!"union".equals(this.lcToken)) {
            ++this.indent;
        }
        this.newline();
        this.afterBeginBeforeEnd = false;
        this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
    }

    private void beginNewClause() {
        if (!this.afterBeginBeforeEnd) {
            if (this.afterOn) {
                --this.indent;
                this.afterOn = false;
            }
            --this.indent;
            this.newline();
        }
        this.out();
        this.beginLine = false;
        this.afterBeginBeforeEnd = true;
    }

    private void values() {
        --this.indent;
        this.newline();
        this.out();
        ++this.indent;
        this.newline();
        this.afterValues = true;
    }

    private void closeParen() {
        --this.parensSinceSelect;
        if (this.parensSinceSelect < 0) {
            --this.indent;
            this.parensSinceSelect = (Integer)this.parenCounts.removeLast();
            this.afterByOrSetOrFromOrSelect = (Boolean)this.afterByOrFromOrSelects.removeLast();
        }
        if (this.inFunction > 0) {
            --this.inFunction;
            this.out();
        } else {
            if (!this.afterByOrSetOrFromOrSelect) {
                --this.indent;
                this.newline();
            }
            this.out();
        }
        this.beginLine = false;
    }

    private void openParen() {
        if (Formatter.isFunctionName(this.lastToken) || this.inFunction > 0) {
            ++this.inFunction;
        }
        this.beginLine = false;
        if (this.inFunction > 0) {
            this.out();
        } else {
            this.out();
            if (!this.afterByOrSetOrFromOrSelect) {
                ++this.indent;
                this.newline();
                this.beginLine = true;
            }
        }
        ++this.parensSinceSelect;
    }

    private static boolean isFunctionName(String tok) {
        char begin = tok.charAt(0);
        boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
        return isIdentifier && !LOGICAL.contains(tok) && !END_CLAUSES.contains(tok) && !QUANTIFIERS.contains(tok) && !DML.contains(tok) && !MISC.contains(tok);
    }

    private static boolean isWhitespace(String token) {
        return " \n\r\f\t".indexOf(token) >= 0;
    }

    private void newline() {
        this.result.append("\n");
        for (int i = 0; i < this.indent; ++i) {
            this.result.append(this.indentString);
        }
        this.beginLine = true;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println(new Formatter(StringHelper.join(" ", args)).format());
        }
        System.out.println(new Formatter("insert into Address (city, state, zip, \"from\") values (?, ?, ?, 'insert value')").format());
        System.out.println(new Formatter("delete from Address where id = ? and version = ?").format());
        System.out.println(new Formatter("update Address set city = ?, state=?, zip=?, version = ? where id = ? and version = ?").format());
        System.out.println(new Formatter("update Address set city = ?, state=?, zip=?, version = ? where id in (select aid from Person)").format());
        System.out.println(new Formatter("select p.name, a.zipCode, count(*) from Person p left outer join Employee e on e.id = p.id and p.type = 'E' and (e.effective>? or e.effective<?) join Address a on a.pid = p.id where upper(p.name) like 'G%' and p.age > 100 and (p.sex = 'M' or p.sex = 'F') and coalesce( trim(a.street), a.city, (a.zip) ) is not null order by p.name asc, a.zipCode asc").format());
        System.out.println(new Formatter("select ( (m.age - p.age) * 12 ), trim(upper(p.name)) from Person p, Person m where p.mother = m.id and ( p.age = (select max(p0.age) from Person p0 where (p0.mother=m.id)) and p.name like ? )").format());
        System.out.println(new Formatter("select * from Address a join Person p on a.pid = p.id, Person m join Address b on b.pid = m.id where p.mother = m.id and p.name like ?").format());
        System.out.println(new Formatter("select case when p.age > 50 then 'old' when p.age > 18 then 'adult' else 'child' end from Person p where ( case when p.age > 50 then 'old' when p.age > 18 then 'adult' else 'child' end ) like ?").format());
    }

    static {
        BEGIN_CLAUSES.add("left");
        BEGIN_CLAUSES.add("right");
        BEGIN_CLAUSES.add("inner");
        BEGIN_CLAUSES.add("outer");
        BEGIN_CLAUSES.add("group");
        BEGIN_CLAUSES.add("order");
        END_CLAUSES.add("where");
        END_CLAUSES.add("set");
        END_CLAUSES.add("having");
        END_CLAUSES.add("join");
        END_CLAUSES.add("from");
        END_CLAUSES.add("by");
        END_CLAUSES.add("join");
        END_CLAUSES.add("into");
        END_CLAUSES.add("union");
        LOGICAL.add("and");
        LOGICAL.add("or");
        LOGICAL.add("when");
        LOGICAL.add("else");
        LOGICAL.add("end");
        QUANTIFIERS.add("in");
        QUANTIFIERS.add("all");
        QUANTIFIERS.add("exists");
        QUANTIFIERS.add("some");
        QUANTIFIERS.add("any");
        DML.add("insert");
        DML.add("update");
        DML.add("delete");
        MISC.add("select");
        MISC.add("on");
    }
}

