/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.finalcontainers.BooleanContainer;
import org.jboss.serial.finalcontainers.ByteContainer;
import org.jboss.serial.finalcontainers.CharacterContainer;
import org.jboss.serial.finalcontainers.DoubleContainer;
import org.jboss.serial.finalcontainers.FloatContainer;
import org.jboss.serial.finalcontainers.IntegerContainer;
import org.jboss.serial.finalcontainers.LongContainer;
import org.jboss.serial.finalcontainers.ShortContainer;
import org.jboss.serial.objectmetamodel.DataContainerConstants;
import org.jboss.serial.objectmetamodel.DataExport;
import org.jboss.serial.objectmetamodel.ObjectDescriptorFactory;
import org.jboss.serial.objectmetamodel.ObjectReference;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import org.jboss.serial.util.StringUtil;

public class DataContainer
extends DataExport
implements DataContainerConstants,
Externalizable {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$serial$objectmetamodel$DataContainer == null ? (class$org$jboss$serial$objectmetamodel$DataContainer = DataContainer.class$("org.jboss.serial.objectmetamodel.DataContainer")) : class$org$jboss$serial$objectmetamodel$DataContainer));
    ObjectSubstitutionInterface substitution;
    static byte[] openSign = new byte[]{106, 98, 115, 123};
    static byte[] closeSign = new byte[]{106, 98, 115, 125};
    byte[] checkSignBuffer = new byte[4];
    byte[] controlStreaming;
    DataContainerOutput currentOutput = null;
    ArrayList content = new ArrayList();
    transient ObjectsCache cache;
    static /* synthetic */ Class class$org$jboss$serial$objectmetamodel$DataContainer;

    public DataContainer(boolean checkSerializable) {
        this(null, checkSerializable);
    }

    public DataContainer(ClassLoader loader, boolean checkSerializable) {
        this(loader, null, checkSerializable);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable) {
        this(loader, substitution, null, checkSerializable);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable) {
        this(new ObjectsCache(substitution, loader, safeToReuse, checkSerializable));
    }

    public DataContainer(ObjectsCache cache) {
        this.cache = cache;
    }

    public int getSize() {
        return this.content.size();
    }

    public ObjectInput getInput() {
        return new DataContainerInput();
    }

    public ObjectOutput getOutput() {
        if (this.currentOutput == null) {
            this.currentOutput = new DataContainerOutput();
        }
        return this.currentOutput;
    }

    public ObjectOutput getDirectOutput(DataOutputStream dataOut) {
        return new DataContainerDirectOutput(dataOut);
    }

    public ObjectInput getDirectInput(DataInputStream dataInput) {
        return new DataContainerDirectInput(dataInput);
    }

    public void flush() throws IOException {
        if (this.currentOutput != null) {
            this.currentOutput.flushByteArray();
        }
    }

    public ObjectsCache getCache() {
        return this.cache;
    }

    public void saveData(DataOutput output) throws IOException {
        this.flush();
        output.write(openSign);
        output.writeInt(this.getControlStreaming().length);
        output.write(this.getControlStreaming());
        this.writeMyself(output);
        if (output instanceof DataOutputStream) {
            ((DataOutputStream)output).flush();
        }
        output.write(closeSign);
    }

    private void writeReference(DataOutput output, Object obj) throws IOException {
        output.writeByte(3);
        ((ObjectReference)obj).writeMyself(output);
    }

    private void writeInteger(DataOutput output, Object obj) throws IOException {
        if (obj instanceof IntegerContainer) {
            output.writeByte(6);
            output.writeInt(((IntegerContainer)obj).getValue());
        } else {
            output.writeByte(26);
            output.writeInt((Integer)obj);
        }
    }

    private void writeDouble(DataOutput output, Object obj) throws IOException {
        if (obj instanceof DoubleContainer) {
            output.writeByte(5);
            output.writeDouble(((DoubleContainer)obj).getValue());
        } else {
            output.writeByte(25);
            output.writeDouble((Double)obj);
        }
    }

    private void saveString(DataOutput output, Object obj) throws IOException {
        output.writeByte(4);
        StringUtil.saveString(output, (String)obj);
    }

    public void loadData(DataInput input) throws IOException {
        input.readFully(this.checkSignBuffer);
        if (!this.compareBuffer(openSign, this.checkSignBuffer)) {
            throw new SerializationException("Missing signature opening block");
        }
        int size = input.readInt();
        byte[] byteControl = new byte[size];
        input.readFully(byteControl);
        this.setControlStreaming(byteControl);
        this.readMyself(input);
        input.readFully(this.checkSignBuffer);
        if (!this.compareBuffer(closeSign, this.checkSignBuffer)) {
            throw new SerializationException("Missing signature opening block");
        }
    }

    private boolean compareBuffer(byte[] buffer1, byte[] buffer2) {
        for (int i = 0; i < buffer1.length; ++i) {
            if (buffer1[i] == buffer2[i]) continue;
            return false;
        }
        return true;
    }

    public void writeMyself(DataOutput output) throws IOException {
        if (log.isTraceEnabled()) {
            log.debug((Object)("Output = " + output + " content=" + this.content + " size=" + this.content.size()), new Throwable());
        }
        if (this.currentOutput.outByte != null) {
            this.currentOutput.flushByteArray();
        }
        output.writeInt(this.content.size());
        Iterator iter = this.content.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null) {
                output.writeByte(99);
                continue;
            }
            if (obj instanceof String) {
                this.saveString(output, obj);
                continue;
            }
            if (obj instanceof ByteContainer || obj instanceof Byte) {
                this.writeByte(output, obj);
                continue;
            }
            if (obj instanceof CharacterContainer || obj instanceof Character) {
                this.writeCharacter(output, obj);
                continue;
            }
            if (obj instanceof ShortContainer || obj instanceof Short) {
                this.writeShort(output, obj);
                continue;
            }
            if (obj instanceof IntegerContainer || obj instanceof Integer) {
                this.writeInteger(output, obj);
                continue;
            }
            if (obj instanceof LongContainer || obj instanceof Long) {
                this.writeLong(output, obj);
                continue;
            }
            if (obj instanceof DoubleContainer || obj instanceof Double) {
                this.writeDouble(output, obj);
                continue;
            }
            if (obj instanceof FloatContainer || obj instanceof Float) {
                this.writeFloat(output, obj);
                continue;
            }
            if (obj instanceof ObjectReference) {
                this.writeReference(output, obj);
                continue;
            }
            if (obj instanceof BooleanContainer || obj instanceof Boolean) {
                this.writeBoolean(output, obj);
                continue;
            }
            if (obj instanceof byte[]) {
                this.writeByteArray(output, obj);
                continue;
            }
            throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
        }
    }

    private void writeFloat(DataOutput output, Object obj) throws IOException {
        if (obj instanceof FloatContainer) {
            output.writeByte(10);
            output.writeFloat(((FloatContainer)obj).getValue());
        } else {
            output.writeByte(30);
            output.writeFloat(((Float)obj).floatValue());
        }
    }

    private void writeByteArray(DataOutput output, Object obj) throws IOException {
        output.writeByte(13);
        output.writeInt(((byte[])obj).length);
        output.write((byte[])obj);
    }

    private void writeBoolean(DataOutput output, Object obj) throws IOException {
        if (obj instanceof BooleanContainer) {
            output.writeByte(12);
            output.writeBoolean(((BooleanContainer)obj).getValue());
        } else {
            output.writeByte(32);
            output.writeBoolean((Boolean)obj);
        }
    }

    private void writeLong(DataOutput output, Object obj) throws IOException {
        if (obj instanceof LongContainer) {
            output.writeByte(7);
            output.writeLong(((LongContainer)obj).getValue());
        } else {
            output.writeByte(27);
            output.writeLong((Long)obj);
        }
    }

    private void writeShort(DataOutput output, Object obj) throws IOException {
        if (obj instanceof ShortContainer) {
            output.writeByte(8);
            output.writeShort(((ShortContainer)obj).getValue());
        } else {
            output.writeByte(28);
            output.writeShort(((Short)obj).shortValue());
        }
    }

    private void writeCharacter(DataOutput output, Object obj) throws IOException {
        if (obj instanceof Character) {
            output.writeByte(31);
            output.writeChar(((Character)obj).charValue());
        } else {
            output.writeByte(11);
            output.writeChar(((CharacterContainer)obj).getValue());
        }
    }

    private void writeByte(DataOutput output, Object obj) throws IOException {
        if (obj instanceof ByteContainer) {
            output.writeByte(9);
            output.writeByte(((ByteContainer)obj).getValue());
        } else {
            output.writeByte(29);
            output.writeByte(((Byte)obj).byteValue());
        }
    }

    public void readMyself(DataInput input) throws IOException {
        int size = input.readInt();
        this.content.clear();
        block22: for (int i = 0; i < size; ++i) {
            byte type = input.readByte();
            switch (type) {
                case 99: {
                    this.content.add(null);
                    continue block22;
                }
                case 4: {
                    this.content.add(StringUtil.readString(input));
                    continue block22;
                }
                case 9: {
                    this.content.add(new ByteContainer(input.readByte()));
                    continue block22;
                }
                case 29: {
                    this.content.add(new Byte(input.readByte()));
                    continue block22;
                }
                case 8: {
                    this.content.add(new ShortContainer(input.readShort()));
                    continue block22;
                }
                case 28: {
                    this.content.add(new Short(input.readShort()));
                    continue block22;
                }
                case 6: {
                    this.content.add(new IntegerContainer(input.readInt()));
                    continue block22;
                }
                case 26: {
                    this.content.add(new Integer(input.readInt()));
                    continue block22;
                }
                case 7: {
                    this.content.add(new LongContainer(input.readLong()));
                    continue block22;
                }
                case 27: {
                    this.content.add(new Long(input.readLong()));
                    continue block22;
                }
                case 10: {
                    this.content.add(new FloatContainer(input.readFloat()));
                    continue block22;
                }
                case 30: {
                    this.content.add(new Float(input.readFloat()));
                    continue block22;
                }
                case 5: {
                    this.content.add(new DoubleContainer(input.readDouble()));
                    continue block22;
                }
                case 25: {
                    this.content.add(new Double(input.readDouble()));
                    continue block22;
                }
                case 11: {
                    this.content.add(new CharacterContainer(input.readChar()));
                    continue block22;
                }
                case 31: {
                    this.content.add(new Character(input.readChar()));
                    continue block22;
                }
                case 12: {
                    this.content.add(new BooleanContainer(input.readBoolean()));
                    continue block22;
                }
                case 32: {
                    this.content.add(new Boolean(input.readBoolean()));
                    continue block22;
                }
                case 13: {
                    int sizebArray = input.readInt();
                    byte[] barray = new byte[sizebArray];
                    input.readFully(barray);
                    this.content.add(barray);
                    continue block22;
                }
                case 3: {
                    ObjectReference reference = new ObjectReference();
                    reference.readMyself(input);
                    this.content.add(reference);
                    continue block22;
                }
                default: {
                    throw new SerializationException("I don't know how to read type " + type + " yet");
                }
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.saveData(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.loadData(in);
    }

    public byte[] getControlStreaming() {
        if (this.controlStreaming == null) {
            this.controlStreaming = new byte[0];
        }
        return this.controlStreaming;
    }

    public void setControlStreaming(byte[] controlStreaming) {
        this.controlStreaming = controlStreaming;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DataContainerInput
    implements ObjectsCache.JBossSeralizationInputInterface {
        int position = -1;
        Object currentObject = null;
        ByteArrayInputStream byteStreamInput;

        public DataContainerInput() {
            this.byteStreamInput = new ByteArrayInputStream(DataContainer.this.getControlStreaming());
        }

        public void reset() {
            this.position = -1;
            this.byteStreamInput = null;
        }

        boolean moveNext() throws EOFException {
            ++this.position;
            if (this.position >= DataContainer.this.content.size()) {
                throw new EOFException("Unexpected end of repository");
            }
            this.currentObject = DataContainer.this.content.get(this.position);
            return this.position < DataContainer.this.content.size();
        }

        public Object readObject() throws ClassNotFoundException, IOException {
            this.moveNext();
            DataContainer.this.cache.setInput(this);
            if (this.currentObject instanceof ObjectReference) {
                return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, (ObjectReference)this.currentObject, this);
            }
            return this.currentObject;
        }

        public ObjectReference readObjectReference() throws IOException {
            this.moveNext();
            return (ObjectReference)this.currentObject;
        }

        public byte readByteDirectly() throws IOException {
            return this.readByte();
        }

        public int read() throws IOException {
            return this.byteStreamInput.read();
        }

        public int read(byte[] b) throws IOException {
            return this.byteStreamInput.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.byteStreamInput.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.byteStreamInput.skip(n);
        }

        public int available() throws IOException {
            return this.byteStreamInput.available();
        }

        public void close() throws IOException {
        }

        public void readFully(byte[] b) throws IOException {
            this.byteStreamInput.read(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.byteStreamInput.read(b, off, len);
        }

        public int skipBytes(int n) throws IOException {
            return (int)this.byteStreamInput.skip(n);
        }

        public boolean readBoolean() throws IOException {
            this.moveNext();
            try {
                return ((BooleanContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be boolean", e);
            }
        }

        public byte readByte() throws IOException {
            return (byte)this.byteStreamInput.read();
        }

        public int readUnsignedByte() throws IOException {
            return this.byteStreamInput.read();
        }

        public short readShort() throws IOException {
            this.moveNext();
            try {
                return ((ShortContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be short", e);
            }
        }

        public int readUnsignedShort() throws IOException {
            this.moveNext();
            try {
                return ((ShortContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be short", e);
            }
        }

        public char readChar() throws IOException {
            this.moveNext();
            try {
                return ((CharacterContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be char", e);
            }
        }

        public int readInt() throws IOException {
            this.moveNext();
            try {
                return ((IntegerContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be int", e);
            }
        }

        public long readLong() throws IOException {
            this.moveNext();
            try {
                return ((LongContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be long", e);
            }
        }

        public float readFloat() throws IOException {
            this.moveNext();
            try {
                return ((FloatContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be float", e);
            }
        }

        public double readDouble() throws IOException {
            this.moveNext();
            try {
                return ((DoubleContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be double", e);
            }
        }

        public String readLine() throws IOException {
            return this.readLine();
        }

        public String readUTF() throws IOException {
            this.moveNext();
            try {
                return (String)this.currentObject;
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be String", e);
            }
        }
    }

    class DataContainerDirectInput
    implements ObjectsCache.JBossSeralizationInputInterface {
        DataInputStream dataInp;

        public DataContainerDirectInput(DataInputStream dataInp) {
            this.dataInp = dataInp;
        }

        public ObjectReference readObjectReference() throws IOException {
            ObjectReference objRef = new ObjectReference();
            objRef.readMyself(this.dataInp);
            return objRef;
        }

        public byte readByteDirectly() throws IOException {
            return (byte)this.read();
        }

        public Object readObject() throws ClassNotFoundException, IOException {
            byte byteRef = (byte)this.dataInp.read();
            if (byteRef == 99) {
                return null;
            }
            DataContainer.this.cache.setInput(this);
            return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, this.readObjectReference(), this);
        }

        public int read() throws IOException {
            return this.dataInp.read();
        }

        public long skip(long n) throws IOException {
            return this.dataInp.skip(n);
        }

        public int available() throws IOException {
            return this.dataInp.available();
        }

        public void close() throws IOException {
            this.dataInp.close();
        }

        public int read(byte[] b) throws IOException {
            return this.dataInp.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.dataInp.read(b, off, len);
        }

        public void readFully(byte[] b) throws IOException {
            this.dataInp.readFully(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.dataInp.readFully(b, off, len);
        }

        public int skipBytes(int n) throws IOException {
            return this.dataInp.skipBytes(n);
        }

        public boolean readBoolean() throws IOException {
            return this.dataInp.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.dataInp.readByte();
        }

        public int readUnsignedByte() throws IOException {
            return this.dataInp.readUnsignedByte();
        }

        public short readShort() throws IOException {
            return this.dataInp.readShort();
        }

        public int readUnsignedShort() throws IOException {
            return this.dataInp.readUnsignedShort();
        }

        public char readChar() throws IOException {
            return this.dataInp.readChar();
        }

        public int readInt() throws IOException {
            return this.dataInp.readInt();
        }

        public long readLong() throws IOException {
            return this.dataInp.readLong();
        }

        public float readFloat() throws IOException {
            return this.dataInp.readFloat();
        }

        public double readDouble() throws IOException {
            return this.dataInp.readDouble();
        }

        public String readLine() throws IOException {
            return this.dataInp.readLine();
        }

        public String readUTF() throws IOException {
            return StringUtil.readString(this.dataInp);
        }

        public String readUTF(DataInput in) throws IOException {
            return DataInputStream.readUTF(in);
        }
    }

    class DataContainerOutput
    implements ObjectsCache.JBossSeralizationOutputInterface {
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();

        DataContainerOutput() {
        }

        private void flushByteArray() {
            if (this.outByte != null) {
                byte[] controlStreaming = this.outByte.toByteArray();
                DataContainer.this.setControlStreaming(controlStreaming);
            }
        }

        public void writeObject(Object obj) throws IOException {
            if (obj == null) {
                DataContainer.this.content.add(null);
            } else if (ClassMetamodelFactory.isImmutable(obj.getClass())) {
                DataContainer.this.content.add(obj);
            } else {
                DataContainer.this.cache.setOutput(this);
                ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj, DataContainer.this.substitution);
            }
        }

        public void addObjectReference(ObjectReference reference) {
            DataContainer.this.content.add(reference);
        }

        public void writeByteDirectly(byte parameter) throws IOException {
            this.writeByte(parameter);
        }

        public void openObjectDefinition() throws IOException {
        }

        public void closeObjectDefinition() throws IOException {
        }

        public void write(int b) throws IOException {
            this.outByte.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.outByte.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outByte.write(b, off, len);
        }

        public void flush() throws IOException {
            this.flushByteArray();
        }

        public void close() throws IOException {
            this.flush();
        }

        public void writeBoolean(boolean v) throws IOException {
            DataContainer.this.content.add(new BooleanContainer(v));
        }

        public void writeByte(int v) throws IOException {
            this.outByte.write(v);
        }

        public void writeShort(int v) throws IOException {
            DataContainer.this.content.add(new ShortContainer((short)v));
        }

        public void writeChar(int v) throws IOException {
            DataContainer.this.content.add(new CharacterContainer((char)v));
        }

        public void writeInt(int v) throws IOException {
            DataContainer.this.content.add(new IntegerContainer(v));
        }

        public void writeLong(long v) throws IOException {
            DataContainer.this.content.add(new LongContainer(v));
        }

        public void writeFloat(float v) throws IOException {
            DataContainer.this.content.add(new FloatContainer(v));
        }

        public void writeDouble(double v) throws IOException {
            DataContainer.this.content.add(new DoubleContainer(v));
        }

        public void writeBytes(String s) throws IOException {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.write(chars[i]);
            }
        }

        public void writeChars(String s) throws IOException {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.writeChar(chars[i]);
            }
        }

        public void writeUTF(String str) throws IOException {
            DataContainer.this.content.add(str);
        }

        public boolean isCheckSerializableClass() {
            return DataContainer.this.cache.isCheckSerializableClass();
        }
    }

    class DataContainerDirectOutput
    implements ObjectsCache.JBossSeralizationOutputInterface {
        DataOutputStream dataOut;

        public void addObjectReference(ObjectReference reference) throws IOException {
            reference.writeMyself(this.dataOut);
        }

        public void openObjectDefinition() throws IOException {
        }

        public void closeObjectDefinition() throws IOException {
        }

        public void writeByteDirectly(byte parameter) throws IOException {
            this.write(parameter);
        }

        public boolean isCheckSerializableClass() {
            return DataContainer.this.getCache().isCheckSerializableClass();
        }

        public void writeObject(Object obj) throws IOException {
            if (obj == null) {
                this.dataOut.write(99);
            } else {
                this.dataOut.write(51);
                DataContainer.this.cache.setOutput(this);
                ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj, DataContainer.this.substitution);
            }
        }

        public void write(byte[] b) throws IOException {
            this.dataOut.write(b);
        }

        public void close() throws IOException {
            this.dataOut.close();
        }

        public DataContainerDirectOutput(DataOutputStream dataOut) {
            this.dataOut = dataOut;
        }

        public void write(int b) throws IOException {
            this.dataOut.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dataOut.write(b, off, len);
        }

        public void flush() throws IOException {
            this.dataOut.flush();
        }

        public void writeBoolean(boolean v) throws IOException {
            this.dataOut.writeBoolean(v);
        }

        public void writeByte(int v) throws IOException {
            this.dataOut.writeByte(v);
        }

        public void writeShort(int v) throws IOException {
            this.dataOut.writeShort(v);
        }

        public void writeChar(int v) throws IOException {
            this.dataOut.writeChar(v);
        }

        public void writeInt(int v) throws IOException {
            this.dataOut.writeInt(v);
        }

        public void writeLong(long v) throws IOException {
            this.dataOut.writeLong(v);
        }

        public void writeFloat(float v) throws IOException {
            this.dataOut.writeFloat(v);
        }

        public void writeDouble(double v) throws IOException {
            this.dataOut.writeDouble(v);
        }

        public void writeBytes(String s) throws IOException {
            this.dataOut.writeBytes(s);
        }

        public void writeChars(String s) throws IOException {
            this.dataOut.writeChars(s);
        }

        public void writeUTF(String str) throws IOException {
            StringUtil.saveString(this.dataOut, str);
        }

        public int size() {
            return this.dataOut.size();
        }
    }
}

