/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.jboss.logging.Logger;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.DataContainer;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;

public class JBossObjectOutputStream
extends ObjectOutputStream {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$serial$io$JBossObjectOutputStream == null ? (class$org$jboss$serial$io$JBossObjectOutputStream = JBossObjectOutputStream.class$("org.jboss.serial.io.JBossObjectOutputStream")) : class$org$jboss$serial$io$JBossObjectOutputStream));
    OutputStream output;
    DataOutputStream dataOutput;
    boolean checkSerializableClass = false;
    static Field fieldEnableReplace;
    static /* synthetic */ Class class$org$jboss$serial$io$JBossObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;

    private ObjectSubstitutionInterface getSubstitutionInterface() throws IOException {
        try {
            if (fieldEnableReplace.getBoolean(this)) {
                return new ObjectSubstitutionInterface(){

                    public Object replaceObject(Object obj) throws IOException {
                        return JBossObjectOutputStream.this.replaceObject(obj);
                    }
                };
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException(ex.getMessage(), ex);
        }
    }

    protected boolean enableReplaceObject(boolean enable) {
        try {
            if (enable == fieldEnableReplace.getBoolean(this)) {
                return enable;
            }
            fieldEnableReplace.setBoolean(this, enable);
            return !fieldEnableReplace.getBoolean(this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return super.enableReplaceObject(enable);
        }
    }

    public JBossObjectOutputStream(OutputStream output) throws IOException {
        this(output, false);
    }

    public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass) throws IOException {
        this.output = output;
        this.checkSerializableClass = checkSerializableClass;
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        ObjectOutput objectOutput = dataContainer.getOutput();
        objectOutput.writeObject(obj);
        objectOutput.flush();
        dataContainer.saveData(this.dataOutput);
        this.flush();
    }

    public void writeObjectDirect(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        ObjectOutput objectOutput = dataContainer.getDirectOutput(this.dataOutput);
        objectOutput.writeObject(obj);
        objectOutput.flush();
        this.flush();
    }

    public void writeUnshared(Object obj) throws IOException {
        this.writeObjectOverride(obj);
    }

    public void defaultWriteObject() throws IOException {
    }

    public void writeFields() throws IOException {
    }

    public void reset() throws IOException {
    }

    protected void writeStreamHeader() throws IOException {
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
    }

    public void write(int val) throws IOException {
        this.dataOutput.write(val);
    }

    public void write(byte[] buf) throws IOException {
        this.dataOutput.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new SerializationException("buf parameter can't be null");
        }
        this.dataOutput.write(buf, off, len);
    }

    public void flush() throws IOException {
        if (this.dataOutput != null) {
            this.dataOutput.flush();
        } else {
            this.output.flush();
        }
    }

    protected void drain() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this.dataOutput.close();
        this.dataOutput.close();
    }

    public void writeBoolean(boolean val) throws IOException {
        this.dataOutput.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.dataOutput.writeByte(val);
    }

    public void writeShort(int val) throws IOException {
        this.dataOutput.writeShort(val);
    }

    public void writeChar(int val) throws IOException {
        this.dataOutput.writeChar(val);
    }

    public void writeInt(int val) throws IOException {
        this.dataOutput.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.dataOutput.writeLong(val);
    }

    public void writeFloat(float val) throws IOException {
        this.dataOutput.writeFloat(val);
    }

    public void writeDouble(double val) throws IOException {
        this.dataOutput.writeDouble(val);
    }

    public void writeBytes(String str) throws IOException {
        this.dataOutput.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        this.dataOutput.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        this.dataOutput.writeUTF(str);
    }

    public Object smartClone(Object obj) throws IOException {
        return this.smartClone(obj, null, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse) throws IOException {
        return this.smartClone(obj, safeToReuse, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse, ClassLoader loader) throws IOException {
        DataContainer container = new DataContainer(loader, this.getSubstitutionInterface(), safeToReuse, this.checkSerializableClass);
        ObjectOutput output = container.getOutput();
        output.writeObject(obj);
        output.flush();
        ObjectInput input = container.getInput();
        try {
            return input.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            fieldEnableReplace = (class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = JBossObjectOutputStream.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream).getDeclaredField("enableReplace");
            fieldEnableReplace.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

