/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;

public class PropertyHelper {
    public Object getValue(Object bean, String name) {
        PropertyDescriptor descriptor = this.descriptor(bean, name);
        Method method = descriptor.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(name);
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getCause());
        }
        catch (Exception e) {
            throw new EvaluationException((Throwable)e);
        }
    }

    public boolean isReadOnly(Object bean, String name) {
        PropertyDescriptor descriptor = this.descriptor(bean, name);
        if (descriptor.getReadMethod() != null) {
            return descriptor.getWriteMethod() == null;
        }
        throw new PropertyNotFoundException(name);
    }

    public Class getType(Object bean, String name) {
        PropertyDescriptor descriptor = this.descriptor(bean, name);
        return descriptor.getPropertyType();
    }

    public void setValue(Object bean, String name, Object value) {
        PropertyDescriptor descriptor = this.descriptor(bean, name);
        Method method = descriptor.getWriteMethod();
        if (method == null) {
            throw new PropertyNotFoundException(name);
        }
        try {
            method.invoke(bean, value);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getCause());
        }
        catch (Exception e) {
            throw new EvaluationException((Throwable)e);
        }
    }

    private PropertyDescriptor descriptor(Object bean, String name) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new EvaluationException((Throwable)e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!name.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        throw new PropertyNotFoundException(name);
    }
}

