/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.model.SelectItem;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.shale.remote.RemoteContext;
import org.apache.shale.remote.ResponseWrapper;

public abstract class AbstractSelectItems
implements Command {
    protected static final String PARAMETER = "prefix";

    protected String getInnerDescriptionElement() {
        return "description";
    }

    protected String getInnerLabelElement() {
        return "label";
    }

    protected String getInnerValueElement() {
        return "value";
    }

    protected String getInnerElement() {
        return "item";
    }

    protected String getOuterElement() {
        return "items";
    }

    public boolean execute(Context context) throws Exception {
        RemoteContext rcontext = (RemoteContext)context;
        String test = this.test(rcontext);
        SelectItem[] legal = this.legal(rcontext, test);
        SelectItem[] matches = this.match(rcontext, test, legal);
        this.render(rcontext, matches);
        return true;
    }

    protected abstract SelectItem[] legal(RemoteContext var1, String var2);

    protected SelectItem[] match(RemoteContext context, String test, SelectItem[] legal) {
        if (test == null || test.length() == 0) {
            return legal;
        }
        if (legal == null) {
            return new SelectItem[0];
        }
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        String match = test.toLowerCase();
        for (int i = 0; i < legal.length; ++i) {
            if (!legal[i].getLabel().toLowerCase().startsWith(match)) continue;
            list.add(legal[i]);
        }
        return list.toArray(new SelectItem[list.size()]);
    }

    protected void render(RemoteContext context, SelectItem[] matches) throws IOException {
        context.setResponseContentType("text/xml");
        context.setResponseEncoding("UTF-8");
        ResponseWrapper wrapper = new ResponseWrapper(context.getResponseWriter(), "UTF-8");
        String inner = this.getInnerElement();
        String innerDescription = this.getInnerDescriptionElement();
        String innerLabel = this.getInnerLabelElement();
        String innerValue = this.getInnerValueElement();
        String outer = this.getOuterElement();
        wrapper.startDocument();
        wrapper.startElement(outer);
        wrapper.writeNewline();
        for (int i = 0; i < matches.length; ++i) {
            String description;
            String label;
            if (matches[i] == null) continue;
            wrapper.startElement(inner);
            wrapper.writeNewline();
            Object value = matches[i].getValue();
            if (value != null) {
                wrapper.startElement(innerValue);
                wrapper.writeText(value.toString());
                wrapper.endElement(innerValue);
                wrapper.writeNewline();
            }
            if ((label = matches[i].getLabel()) != null) {
                wrapper.startElement(innerLabel);
                wrapper.writeText(label);
                wrapper.endElement(innerLabel);
                wrapper.writeNewline();
            }
            if ((description = matches[i].getDescription()) != null) {
                wrapper.startElement(innerDescription);
                wrapper.writeText(description);
                wrapper.endElement(innerDescription);
                wrapper.writeNewline();
            }
            wrapper.endElement(inner);
            wrapper.writeNewline();
        }
        wrapper.endElement(outer);
        wrapper.endDocument();
    }

    protected String test(RemoteContext context) {
        String[] prefixes = (String[])context.getRequestParameters().get(PARAMETER);
        if (prefixes == null) {
            prefixes = new String[]{};
        }
        return prefixes.length > 0 ? prefixes[0] : null;
    }
}

