/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.shale.validator.CommonsValidator;

public class ValidatorScript
extends UIComponentBase {
    private String functionName;
    private Map validators = new LinkedHashMap();

    public String getRendererType() {
        return null;
    }

    public String getFamily() {
        return null;
    }

    public String getFunctionName() {
        if (this.functionName != null) {
            return this.functionName;
        }
        ValueBinding _vb = this.getValueBinding("functionName");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.functionName = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.functionName};
        return values;
    }

    private Map getValidatorsGroupByFormName() {
        LinkedHashMap formValidators = new LinkedHashMap();
        Iterator vi = this.validators.entrySet().iterator();
        while (vi.hasNext()) {
            Map.Entry typeEntry = vi.next();
            Map typeMap = (Map)typeEntry.getValue();
            String type = (String)typeEntry.getKey();
            Iterator ti = typeMap.entrySet().iterator();
            while (ti.hasNext()) {
                LinkedHashMap<String, CommonsValidator> formTypeIdMap;
                Map.Entry idEntry = ti.next();
                String id = (String)idEntry.getKey();
                CommonsValidator v = (CommonsValidator)idEntry.getValue();
                String formName = v.getFormName();
                LinkedHashMap<String, LinkedHashMap<String, CommonsValidator>> formTypeMap = (LinkedHashMap<String, LinkedHashMap<String, CommonsValidator>>)formValidators.get(formName);
                if (formTypeMap == null) {
                    formTypeMap = new LinkedHashMap<String, LinkedHashMap<String, CommonsValidator>>();
                    formValidators.put(formName, formTypeMap);
                }
                if ((formTypeIdMap = (LinkedHashMap<String, CommonsValidator>)formTypeMap.get(type)) == null) {
                    formTypeIdMap = new LinkedHashMap<String, CommonsValidator>();
                    formTypeMap.put(type, formTypeIdMap);
                }
                formTypeIdMap.put(id, v);
            }
        }
        return formValidators;
    }

    private void addValidator(String type, String id, CommonsValidator v) {
        LinkedHashMap<String, CommonsValidator> map = (LinkedHashMap<String, CommonsValidator>)this.validators.get(type);
        if (map == null) {
            map = new LinkedHashMap<String, CommonsValidator>();
            this.validators.put(type, map);
        }
        if (id != null) {
            map.put(id, v);
        }
    }

    private void findCommonsValidators(UIComponent c, FacesContext context) {
        if (c instanceof EditableValueHolder) {
            EditableValueHolder h = (EditableValueHolder)c;
            Validator[] vs = h.getValidators();
            for (int i = 0; i < vs.length; ++i) {
                if (!(vs[i] instanceof CommonsValidator)) continue;
                CommonsValidator v = (CommonsValidator)vs[i];
                v.setFormName(this.findForm(context, c));
                if (Boolean.TRUE.equals(v.getClient())) {
                    Set clientIds = (Set)c.getAttributes().get("org.apache.shale.validator.clientIdSet");
                    if (clientIds != null) {
                        Iterator ci = clientIds.iterator();
                        while (ci.hasNext()) {
                            String id = (String)ci.next();
                            this.addValidator(v.getType(), id, v);
                            ValidatorAction action = v.getValidatorAction();
                            List list = action.getDependencyList();
                            Iterator iter = list.iterator();
                            while (iter.hasNext()) {
                                String type = (String)iter.next();
                                this.addValidator(type, id, v);
                            }
                        }
                    } else {
                        String id = c.getClientId(context);
                        this.addValidator(v.getType(), id, v);
                        ValidatorAction action = v.getValidatorAction();
                        List list = action.getDependencyList();
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            String type = (String)iter.next();
                            this.addValidator(type, id, v);
                        }
                    }
                }
                if (!Boolean.TRUE.equals(v.getServer()) || !"required".equals(v.getType())) continue;
                h.setRequired(true);
            }
        }
        Iterator childrenIterator = c.getFacetsAndChildren();
        while (childrenIterator.hasNext()) {
            UIComponent child = (UIComponent)childrenIterator.next();
            this.findCommonsValidators(child, context);
        }
        childrenIterator = null;
    }

    private void writeScriptStart(ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("language", (Object)"Javascript1.1", null);
        writer.write("\n<!--\n");
    }

    private void writeScriptEnd(ResponseWriter writer) throws IOException {
        writer.write("\n-->\n");
        writer.endElement("script");
    }

    private void writeValidationFunctions(ResponseWriter writer, FacesContext context) throws IOException {
        writer.write("var bCancel = false;\n");
        writer.write("function ");
        writer.write(this.getAttributes().get("functionName").toString());
        writer.write("(form) { return bCancel || true\n");
        Iterator<Object> iter = this.getTypesOrderedByDependencies(this.validators.keySet()).iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            ValidatorAction a = CommonsValidator.getValidatorAction(type);
            writer.write("&& ");
            writer.write(a.getJsFunctionName());
            writer.write("(form)\n");
        }
        writer.write(";}\n");
        Map formValidators = this.getValidatorsGroupByFormName();
        Iterator formIter = formValidators.entrySet().iterator();
        while (formIter.hasNext()) {
            Map.Entry typeEntry = formIter.next();
            String formName = (String)typeEntry.getKey();
            Map formTypeValidators = (Map)typeEntry.getValue();
            iter = formTypeValidators.keySet().iterator();
            while (iter.hasNext()) {
                String type = (String)iter.next();
                ValidatorAction a = CommonsValidator.getValidatorAction(type);
                writer.write("function ");
                StringBuffer callback = new StringBuffer();
                String fnameMnemonic = CommonsValidator.getJsCallbackMnemonic(type);
                callback.append(formName).append('_').append(fnameMnemonic);
                writer.write(callback.toString());
                writer.write("() { \n");
                Map map = (Map)formTypeValidators.get(type);
                Iterator iter2 = map.keySet().iterator();
                int k = 0;
                while (iter2.hasNext()) {
                    String id = (String)iter2.next();
                    CommonsValidator v = (CommonsValidator)map.get(id);
                    writer.write("this[" + k + "] = ");
                    ++k;
                    this.writeJavaScriptParams(writer, context, id, v);
                    writer.write(";\n");
                }
                writer.write("}\n");
            }
        }
        formValidators.clear();
        ArrayList types = new ArrayList(this.validators.keySet());
        types.add("includeJavaScriptUtilities");
        iter = types.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            ValidatorAction a = CommonsValidator.getValidatorAction(type);
            writer.write(a.getJavascript());
            writer.write("\n");
        }
        types.clear();
    }

    private String escapeJavascript(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuffer out = new StringBuffer(length + 4);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'' || c == '\\' || c == '\n' || c == '\r') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    private List getTypesOrderedByDependencies(Set typeSet) {
        ArrayList<String> tmpList = new ArrayList<String>(typeSet);
        for (int i = 0; i < tmpList.size(); ++i) {
            boolean swap = false;
            for (int j = 0; j < tmpList.size(); ++j) {
                String type = (String)tmpList.get(j);
                ValidatorAction a = CommonsValidator.getValidatorAction(type);
                List dependencies = a.getDependencyList();
                if (dependencies == null || dependencies.size() <= 0) continue;
                int max = -1;
                for (int n = 0; n < dependencies.size(); ++n) {
                    max = Math.max(max, tmpList.indexOf(dependencies.get(n)));
                }
                if (max <= j) continue;
                String tmp = (String)tmpList.get(j);
                tmpList.remove(j);
                tmpList.add(max, tmp);
                swap = true;
                j = max;
            }
            if (!swap) break;
        }
        return tmpList;
    }

    public void writeJavaScriptParams(ResponseWriter writer, FacesContext context, String id, CommonsValidator v) throws IOException {
        ValidatorAction validatorAction = v.getValidatorAction();
        writer.write("new Array(\"");
        writer.write(id);
        writer.write("\", \"");
        writer.write(v.getErrorMessage(context, validatorAction));
        writer.write("\", new Function(\"x\", \"return {");
        Iterator vi = v.getVars().entrySet().iterator();
        boolean first = true;
        while (vi.hasNext()) {
            Map.Entry e = vi.next();
            Object value = e.getValue();
            if (value == null) continue;
            String name = (String)e.getKey();
            if (!first) {
                writer.write(",");
            } else {
                first = false;
            }
            writer.write(name);
            writer.write(":");
            String jsType = v.getVarType(name);
            if (jsType.equals("regexp")) {
                writer.write("/");
            } else {
                writer.write("'");
            }
            writer.write(this.escapeJavascript(value.toString()));
            if (jsType.equals("regexp")) {
                writer.write("/");
                continue;
            }
            writer.write("'");
        }
        writer.write("}[x];\"))");
    }

    public String findForm(FacesContext context, UIComponent component) {
        UIComponent parent = null;
        parent = component.getParent();
        if (parent != null) {
            if (parent instanceof UIForm) {
                return parent.getClientId(context);
            }
            return this.findForm(context, parent);
        }
        return "";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.validators.clear();
        this.findCommonsValidators((UIComponent)context.getViewRoot(), context);
        this.writeScriptStart(writer);
        this.writeValidationFunctions(writer, context);
        this.writeScriptEnd(writer);
    }
}

