/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.shale.faces.ShaleWebContext;
import org.apache.shale.remote.ServletRemoteContext;

public class RemoteCommand
implements Command {
    private String catalogName = "remote";
    private String lifecycleId = "DEFAULT";
    private String patterns = "\\S*\\.remote";
    private boolean usingFacesContext = true;
    private Catalog catalog = null;
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private Pattern[] match = null;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getLifecycleId() {
        return this.lifecycleId;
    }

    public void setLifecycleId(String lifecycleId) {
        this.lifecycleId = lifecycleId;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    public boolean isUsingFacesContext() {
        return this.usingFacesContext;
    }

    public void setUsingFacesContext(boolean usingFacesContext) {
        this.usingFacesContext = usingFacesContext;
    }

    public boolean execute(Context context) throws Exception {
        String uri;
        String pathInfo;
        ShaleWebContext swcontext = (ShaleWebContext)context;
        HttpServletRequest request = swcontext.getRequest();
        String servletPath = request.getServletPath();
        if (servletPath == null) {
            servletPath = "";
        }
        if ((pathInfo = request.getPathInfo()) == null) {
            pathInfo = "";
        }
        if (!this.match(uri = servletPath + pathInfo)) {
            return false;
        }
        Command command = this.catalog().getCommand(uri);
        if (command == null) {
            return true;
        }
        FacesContext facesContext = null;
        if (this.isUsingFacesContext()) {
            facesContext = this.facesContextFactory().getFacesContext((Object)swcontext.getContext(), (Object)swcontext.getRequest(), (Object)swcontext.getResponse(), this.lifecycle());
        }
        ServletRemoteContext rcontext = new ServletRemoteContext(swcontext.getContext(), swcontext.getRequest(), swcontext.getResponse());
        command.execute((Context)rcontext);
        if (facesContext != null) {
            facesContext.responseComplete();
        }
        return true;
    }

    private Catalog catalog() {
        if (this.catalog == null) {
            this.catalog = CatalogFactory.getInstance().getCatalog(this.catalogName);
        }
        return this.catalog;
    }

    private FacesContextFactory facesContextFactory() {
        if (this.facesContextFactory == null) {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.facesContextFactory;
    }

    private Lifecycle lifecycle() {
        if (this.lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        }
        return this.lifecycle;
    }

    private boolean match(String uri) {
        if (this.match == null) {
            this.match = this.precompile(this.patterns);
        }
        for (int i = 0; i < this.match.length; ++i) {
            if (!this.match[i].matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    private Pattern[] precompile(String expr) {
        ArrayList<Pattern> list;
        block5: {
            if (expr == null) {
                return new Pattern[0];
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(expr));
            st.eolIsSignificant(false);
            st.lowerCaseMode(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(0, 255);
            st.quoteChar(39);
            st.quoteChar(34);
            st.whitespaceChars(0, 32);
            st.whitespaceChars(44, 44);
            list = new ArrayList<Pattern>();
            int type = 0;
            while (true) {
                try {
                    type = st.nextToken();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (type == -1) break block5;
                if (type == -2) {
                    list.add(Pattern.compile("" + st.nval));
                    continue;
                }
                if (type != -3) break;
                list.add(Pattern.compile(st.sval.trim()));
            }
            throw new IllegalArgumentException(expr);
        }
        return list.toArray(new Pattern[list.size()]);
    }
}

