/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.faces;

import java.beans.Beans;
import java.util.Map;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.shale.util.LoadBundle;

public class ShalePropertyResolver
extends PropertyResolver {
    private PropertyResolver original = null;

    public ShalePropertyResolver(PropertyResolver original) {
        this.original = original;
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            Context context = (Context)base;
            try {
                if (property instanceof Name) {
                    return context.lookup((Name)property);
                }
                return context.lookup(property.toString());
            }
            catch (NameNotFoundException e) {
                return null;
            }
            catch (NamingException e) {
                throw new EvaluationException((Throwable)e);
            }
        }
        if (base instanceof LoadBundle && !"basename".equals(property)) {
            Map map = ((LoadBundle)base).getMap();
            if ("map".equals(property)) {
                return map;
            }
            return map.get(property);
        }
        return this.original.getValue(base, property);
    }

    public void setValue(Object base, Object property, Object value) {
        if (base instanceof Context) {
            Context context = (Context)base;
            try {
                if (property instanceof Name) {
                    context.rebind((Name)property, value);
                }
                context.rebind(property.toString(), value);
            }
            catch (NamingException e) {
                throw new EvaluationException((Throwable)e);
            }
        } else {
            if (base instanceof LoadBundle && !"basename".equals(property)) {
                throw new PropertyNotFoundException("" + value);
            }
            this.original.setValue(base, property, value);
        }
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            return false;
        }
        if (base instanceof LoadBundle && !"basename".equals(property)) {
            return true;
        }
        return this.original.isReadOnly(base, property);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            Object value;
            Context context = (Context)base;
            try {
                value = property instanceof Name ? context.lookup((Name)property) : context.lookup(property.toString());
            }
            catch (NameNotFoundException e) {
                return null;
            }
            catch (NamingException e) {
                throw new EvaluationException((Throwable)e);
            }
            if (value == null) {
                return null;
            }
            return value.getClass();
        }
        if (base instanceof LoadBundle && !"basename".equals(property)) {
            LoadBundle lb = (LoadBundle)base;
            if ("map".equals(property)) {
                return Map.class;
            }
            if (Beans.isDesignTime()) {
                return Object.class;
            }
            Object value = lb.getMap().get(property);
            if (value != null) {
                return value.getClass();
            }
            return null;
        }
        return this.original.getType(base, property);
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            return this.getValue(base, "" + index);
        }
        if (base instanceof LoadBundle && !"basename".equals(base)) {
            return this.getValue(base, "" + index);
        }
        return this.original.getValue(base, index);
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            this.setValue(base, "" + index, value);
        } else if (base instanceof LoadBundle) {
            this.setValue(base, "" + index, value);
        } else {
            this.original.setValue(base, index, value);
        }
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            return this.isReadOnly(base, "" + index);
        }
        if (base instanceof LoadBundle) {
            return this.isReadOnly(base, "" + index);
        }
        return this.original.isReadOnly(base, index);
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof Context) {
            return this.getType(base, "" + index);
        }
        if (base instanceof LoadBundle) {
            return this.getType(base, "" + index);
        }
        return this.original.getType(base, index);
    }
}

