/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.util.Messages;
import org.apache.shale.util.TokenProcessor;

public class Token
extends UIInput {
    private static final Log log = LogFactory.getLog((Class)Token.class);
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", Token.class.getClassLoader());

    public Token() {
        this.setRendererType("org.apache.shale.Token");
    }

    public String getFamily() {
        return "org.apache.shale.Token";
    }

    public void validate(FacesContext context) {
        TokenProcessor tp;
        super.validate(context);
        String token = (String)this.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating token '" + token + "'"));
        }
        if (!(tp = this.getTokenProcessor(context)).verify(context, token)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Validation failed!");
            }
            this.setValid(false);
            String summary = messages.getMessage("token.invalid");
            FacesMessage message = new FacesMessage(summary);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }

    public String getToken() {
        FacesContext context = FacesContext.getCurrentInstance();
        TokenProcessor tp = this.getTokenProcessor(context);
        String token = tp.generate(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating token '" + token + "'"));
        }
        return token;
    }

    private TokenProcessor getTokenProcessor(FacesContext context) {
        TokenProcessor tp = (TokenProcessor)context.getExternalContext().getApplicationMap().get("org.apache.shale.TOKEN_PROCESSOR");
        if (tp == null) {
            tp = new TokenProcessor();
            context.getExternalContext().getApplicationMap().put("org.apache.shale.TOKEN_PROCESSOR", tp);
        }
        return tp;
    }
}

