/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.xmlDefinition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.DefinitionsFactoryException;
import org.apache.tiles.FactoryNotFoundException;
import org.apache.tiles.xmlDefinition.DefinitionsFactory;
import org.apache.tiles.xmlDefinition.FactorySet;
import org.apache.tiles.xmlDefinition.XmlDefinitionsSet;
import org.apache.tiles.xmlDefinition.XmlParser;
import org.xml.sax.SAXException;

public class I18nFactorySet
extends FactorySet {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$tiles$xmlDefinition$I18nFactorySet == null ? (class$org$apache$tiles$xmlDefinition$I18nFactorySet = I18nFactorySet.class$("org.apache.tiles.xmlDefinition.I18nFactorySet")) : class$org$apache$tiles$xmlDefinition$I18nFactorySet));
    public static final String DEFINITIONS_CONFIG_PARAMETER_NAME = "definitions-config";
    public static final String PARSER_DETAILS_PARAMETER_NAME = "definitions-parser-details";
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "definitions-parser-validate";
    public static final String[] DEFAULT_DEFINITION_FILENAMES = new String[]{"/WEB-INF/tileDefinitions.xml", "/WEB-INF/componentDefinitions.xml", "/WEB-INF/instanceDefinitions.xml"};
    private static final int MAX_BUNDLES_SEARCHED = 2;
    public static final String FILENAME_EXTENSION = ".xml";
    protected DefinitionsFactory defaultFactory = null;
    protected transient XmlParser xmlParser;
    protected boolean isValidatingParser = false;
    protected int parserDetailLevel = 0;
    private List filenames = null;
    private Map loaded = null;
    static /* synthetic */ Class class$org$apache$tiles$xmlDefinition$I18nFactorySet;

    public I18nFactorySet() {
    }

    public I18nFactorySet(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        this.initFactory(servletContext, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        String filename;
        String value = (String)properties.get(PARSER_VALIDATE_PARAMETER_NAME);
        if (value != null) {
            this.isValidatingParser = Boolean.valueOf(value);
        }
        if ((value = (String)properties.get(PARSER_DETAILS_PARAMETER_NAME)) != null) {
            try {
                this.parserDetailLevel = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                log.error((Object)"Bad format for parameter 'definitions-parser-details'. Integer expected.");
            }
        }
        if ((filename = (String)properties.get(DEFINITIONS_CONFIG_PARAMETER_NAME)) != null) {
            try {
                this.initFactory(servletContext, filename);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Factory initialized from file '" + filename + "'."));
                return;
            }
            catch (FileNotFoundException ex) {
                log.error((Object)(ex.getMessage() + " : Can't find file '" + filename + "'"));
                throw new FactoryNotFoundException(ex.getMessage() + " : Can't find file '" + filename + "'");
            }
        } else {
            for (int i = 0; i < DEFAULT_DEFINITION_FILENAMES.length; ++i) {
                filename = DEFAULT_DEFINITION_FILENAMES[i];
                try {
                    this.initFactory(servletContext, filename);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Factory initialized from file '" + filename + "'."));
                    continue;
                }
                catch (FileNotFoundException ex) {
                    // empty catch block
                }
            }
        }
    }

    protected void initFactory(ServletContext servletContext, String proposedFilename) throws DefinitionsFactoryException, FileNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(proposedFilename, ",");
        this.filenames = new ArrayList(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            this.filenames.add(tokenizer.nextToken().trim());
        }
        this.loaded = new HashMap();
        this.defaultFactory = this.createDefaultFactory(servletContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("default factory:" + this.defaultFactory));
        }
    }

    protected DefinitionsFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    protected DefinitionsFactory createDefaultFactory(ServletContext servletContext) throws DefinitionsFactoryException, FileNotFoundException {
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        if (rootXmlConfig == null) {
            throw new FileNotFoundException();
        }
        rootXmlConfig.resolveInheritances();
        if (log.isDebugEnabled()) {
            log.debug((Object)rootXmlConfig);
        }
        DefinitionsFactory factory = new DefinitionsFactory(rootXmlConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("factory loaded : " + factory));
        }
        return factory;
    }

    protected Object getDefinitionsFactoryKey(String name, ServletRequest request, ServletContext servletContext) {
        Locale locale = null;
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            if (session != null) {
                locale = (Locale)session.getAttribute("org.apache.tiles.LOCALE");
            }
        }
        catch (ClassCastException ex) {
            log.error((Object)"I18nFactorySet.getDefinitionsFactoryKey");
            ex.printStackTrace();
        }
        return locale;
    }

    protected DefinitionsFactory createFactory(Object key, ServletRequest request, ServletContext servletContext) throws DefinitionsFactoryException {
        if (key == null) {
            return this.getDefaultFactory();
        }
        List possiblePostfixes = I18nFactorySet.calculatePostixes("", (Locale)key);
        XmlDefinitionsSet lastXmlFile = null;
        DefinitionsFactory factory = null;
        String curPostfix = null;
        int i = 0;
        for (i = possiblePostfixes.size() - 1; i >= 0; --i) {
            curPostfix = (String)possiblePostfixes.get(i);
            factory = (DefinitionsFactory)this.loaded.get(curPostfix);
            if (factory != null) {
                return factory;
            }
            lastXmlFile = this.parseXmlFiles(servletContext, curPostfix, null);
            if (lastXmlFile != null) break;
        }
        if (lastXmlFile == null) {
            return this.getDefaultFactory();
        }
        String lastPostfix = curPostfix;
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        for (int j = 0; j < i; ++j) {
            curPostfix = (String)possiblePostfixes.get(j);
            this.parseXmlFiles(servletContext, curPostfix, rootXmlConfig);
        }
        rootXmlConfig.extend(lastXmlFile);
        rootXmlConfig.resolveInheritances();
        factory = new DefinitionsFactory(rootXmlConfig);
        this.loaded.put(lastPostfix, factory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("factory loaded : " + factory));
        }
        return factory;
    }

    private static List calculatePostixes(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        ArrayList<String> result = new ArrayList<String>(2);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(temp.toString());
        return result;
    }

    protected XmlDefinitionsSet parseXmlFiles(ServletContext servletContext, String postfix, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        if (postfix != null && postfix.length() == 0) {
            postfix = null;
        }
        Iterator i = this.filenames.iterator();
        while (i.hasNext()) {
            String filename = this.concatPostfix((String)i.next(), postfix);
            xmlDefinitions = this.parseXmlFile(servletContext, filename, xmlDefinitions);
        }
        return xmlDefinitions;
    }

    protected XmlDefinitionsSet parseXmlFile(ServletContext servletContext, String filename, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        try {
            InputStream input = servletContext.getResourceAsStream(filename);
            if (null == input) {
                try {
                    input = new FileInputStream(servletContext.getRealPath(filename));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (input == null) {
                input = this.getClass().getResourceAsStream(filename);
            }
            if (input == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can't open file '" + filename + "'"));
                }
                return xmlDefinitions;
            }
            this.xmlParser = new XmlParser();
            this.xmlParser.setValidating(this.isValidatingParser);
            if (xmlDefinitions == null) {
                xmlDefinitions = new XmlDefinitionsSet();
            }
            this.xmlParser.parse(input, xmlDefinitions);
        }
        catch (SAXException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while parsing file '" + filename + "'."));
                ex.printStackTrace();
            }
            throw new DefinitionsFactoryException("Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DefinitionsFactoryException("IO Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        return xmlDefinitions;
    }

    private String concatPostfix(String name, String postfix) {
        if (postfix == null) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("I18nFactorySet : \n");
        buff.append("--- default factory ---\n");
        buff.append(this.defaultFactory.toString());
        buff.append("\n--- other factories ---\n");
        Iterator i = this.factories.values().iterator();
        while (i.hasNext()) {
            buff.append(i.next().toString()).append("---------- \n");
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

