/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.ajax4jsf.framework.ajax.xmlfilter.HtmlParser;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.parser.ParserState;
import org.ajax4jsf.io.parser.ParsingContext;
import org.ajax4jsf.io.parser.ParsingStateManager;

public class FastHtmlParser
implements HtmlParser {
    private Set scripts;
    private Set styles;
    private String encoding;
    private String doctype;
    private String viewState;

    public void parse(Reader in, Writer out) throws IOException {
        boolean haveHtml = false;
        boolean haveHead = false;
        if (null != this.scripts || null != this.styles) {
            char c;
            ParsingStateManager stateManager = ParsingStateManager.getInstance();
            ParserState state = stateManager.getInitialState();
            ParsingContext context = new ParsingContext(out);
            while ((c = (char)in.read()) > '\u0000') {
                state = state.getNextState(c, context);
                state.send(c, context);
                if (state == stateManager.ENDELEMENT) {
                    if (context.getLastMatched() == stateManager.HTML) {
                        haveHtml = true;
                        continue;
                    }
                    if (context.getLastMatched() != stateManager.HEAD) continue;
                    haveHead = true;
                    this.writeToHead(out, haveHtml, haveHead);
                    break;
                }
                if (state != stateManager.ELEMENT) continue;
                this.writeToHead(out, haveHtml, haveHead);
                break;
            }
            context.send();
        } else {
            haveHtml = true;
        }
        if (in instanceof FastBufferReader) {
            FastBufferReader fastIn = (FastBufferReader)in;
            fastIn.writeTo(out);
        } else {
            char[] buffer = new char[1024];
            int buffersCount = -1;
            int length = in.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                ++buffersCount;
                length = in.read(buffer);
            }
        }
        if (!haveHtml) {
            out.write("</html>");
        }
    }

    private void writeToHead(Writer out, boolean haveHtml, boolean haveHead) throws IOException {
        Iterator iter;
        if (!haveHead && !haveHtml) {
            out.write("<html>");
        }
        if (!haveHead) {
            out.write("<head>");
        }
        if (null != this.scripts) {
            iter = this.scripts.iterator();
            while (iter.hasNext()) {
                String script = (String)iter.next();
                out.write("<script type='text/javascript' src='");
                out.write(script);
                out.write("'></script>");
            }
        }
        if (null != this.styles) {
            iter = this.styles.iterator();
            while (iter.hasNext()) {
                String style = (String)iter.next();
                out.write("<link rel='stylesheet'  type='text/css' href='");
                out.write(style);
                out.write("' />");
            }
        }
        if (!haveHead) {
            out.write("</head>");
        }
    }

    public Set getScripts() {
        return this.scripts;
    }

    public void setScripts(Set scripts) {
        this.scripts = scripts;
    }

    public Set getStyles() {
        return this.styles;
    }

    public void setStyles(Set styles) {
        this.styles = styles;
    }

    public void parseHtml(InputStream input, Writer output) throws IOException {
        this.parse(new InputStreamReader(input, this.encoding), output);
    }

    public void parseHtml(Reader input, Writer output) throws IOException {
        this.parse(input, output);
    }

    public void setInputEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String encoding) {
    }

    public void setMoveElements(boolean move) {
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setViewState(String viewState) {
        this.viewState = viewState;
    }
}

