/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderers.ajax;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.framework.ajax.AjaxComponent;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;

public abstract class AjaxCommandRendererBase
extends AjaxComponentRendererBase {
    public void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.isSubmitted(facesContext, uiComponent)) {
            AjaxComponent support = (AjaxComponent)uiComponent;
            Object type = uiComponent.getAttributes().get("type");
            if (null == type || !"reset".equalsIgnoreCase((String)type)) {
                ActionEvent event = new ActionEvent(uiComponent);
                uiComponent.queueEvent((FacesEvent)event);
            }
            uiComponent.queueEvent((FacesEvent)new AjaxEvent(uiComponent));
        }
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick;
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            onClick = AjaxRendererUtils.buildOnClick(component, context);
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick = new StringBuffer("return false;");
        }
        return onClick.toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    public Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)uiComponent).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }

    public String getType(UIComponent uiComponent) {
        String type = uiComponent instanceof HtmlCommandButton ? ((HtmlCommandButton)uiComponent).getType() : (String)uiComponent.getAttributes().get("type");
        if (type == null) {
            type = "button";
        }
        return type;
    }

    private boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        if (!AjaxRendererUtils.isAjaxRequest(facesContext)) {
            return false;
        }
        if (this.getUtils().isBooleanAttribute(uiComponent, "disabled")) {
            return false;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Object value = paramMap.get(clientId);
        return null != value;
    }
}

