/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxOutput;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxContainerRenderer
extends AjaxComponentRendererBase {
    public static final String AJAX_PARAMETER_NAME = "AJAXREQUEST";
    public static final String AJAX_JSF_SCRIPT = "AJAX.js";
    public static final String SARISSA_SCRIPT = "sarissa.js";
    public static final String JSDOM_SCRIPT = "JSDOM_sarissa.js";
    public static final String AJAX_VIEW_STATE_TAG = "span";
    public static final String AJAX_VIEW_STATE_ID = "ajax-update-ids";
    public static final String AJAX_RESULT_GROUP_TAG = "meta";
    public static final String AJAX_RESULT_GROUP_ATTR = "content";
    public static final String AJAX_RESULT_STYLE = "display: none";
    public static final String AJAX_UPDATE_HEADER = "Ajax-Update-Ids";
    private static final Log log = LogFactory.getLog((Class)AjaxContainerRenderer.class);
    public static final String AJAX_FLAG_HEADER = "Ajax-Response";
    public static final String AJAX_LOCATION_HEADER = "Location";
    public static final String[] SPECIAL_COMPONENTS_TYPES = new String[]{"org.ajax4jsf.ajax.Bundle", "org.apache.myfaces.AliasBean", "org.apache.myfaces.AliasBeansScope"};
    private static final String SPECIAL_TYPES_PARAMETER = "org.ajax4jsf.CONTROL_COMPONENTS";
    private Set _specialComponentTypes = null;

    protected Class getComponentClass() {
        return AjaxContainer.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        log.debug((Object)Messages.getMessage(Messages.RENDER_CHILDREN_NON_AJAX_INFO));
        this.renderChildren(context, component);
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        AjaxContainer container = (AjaxContainer)component;
        log.debug((Object)Messages.getMessage(Messages.RENDER_CHILDREN_AJAX_INFO));
        Set ids = AjaxRendererUtils.getSubmittedAjaxContainer(context, container).getAjaxAreasToRender();
        Set renderedAreas = container.getAjaxRenderedAreas();
        if (!container.isRenderRegionOnly()) {
            component = context.getViewRoot();
        }
        String path = AjaxRendererUtils.getAbsoluteId(component);
        path = path.substring(0, path.lastIndexOf(58) + 1);
        this.encodeAjaxChild(context, component, path, ids, renderedAreas);
        AjaxRendererUtils.encodeAreas(context, component);
    }

    protected void encodeAjaxChild(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_CHILD_AJAX_INFO, path, component.getId()));
        }
        String currentPath = path;
        if (component instanceof NamingContainer) {
            currentPath = currentPath + component.getId() + ':';
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            boolean found = false;
            UIComponent element = (UIComponent)it.next();
            if (!element.isRendered()) continue;
            if (!ids.isEmpty()) {
                String elementId = element.getId();
                String absoluteId = currentPath + elementId;
                if (ids.contains(absoluteId) || ids.contains(elementId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage(Messages.RENDER_AJAX_AREA_INFO, absoluteId));
                    }
                    found = true;
                }
            }
            if (element instanceof AjaxOutput && ((AjaxOutput)element).isAjaxRendered()) {
                found = true;
            }
            if (!found) {
                boolean special = this.isSpecialElement(context, element);
                if (special) {
                    element.encodeBegin(context);
                }
                this.encodeAjaxChild(context, element, currentPath, ids, renderedAreas);
                if (!special) continue;
                element.encodeEnd(context);
                continue;
            }
            renderedAreas.add(element.getClientId(context));
            this.renderChild(context, element);
        }
    }

    private boolean isSpecialElement(FacesContext context, UIComponent component) {
        boolean result;
        if (this._specialComponentTypes == null) {
            this._specialComponentTypes = new HashSet(10);
            for (int i = 0; i < SPECIAL_COMPONENTS_TYPES.length; ++i) {
                this._specialComponentTypes.add(SPECIAL_COMPONENTS_TYPES[i]);
            }
            String special = context.getExternalContext().getInitParameter(SPECIAL_TYPES_PARAMETER);
            if (null != special) {
                String[] split = special.split(",");
                for (int i = 0; i < split.length; ++i) {
                    this._specialComponentTypes.add(split[i]);
                }
            }
        }
        try {
            String componentType = (String)component.getClass().getField("COMPONENT_TYPE").get(null);
            result = this._specialComponentTypes.contains(componentType);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void preDecode(FacesContext context, UIComponent component) {
        Object ajaxParameter;
        super.preDecode(context, component);
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.DECODE_AJAX_REQUEST_STATUS_INFO, clientId));
            log.debug((Object)Messages.getMessage(Messages.REQUEST_PARAMETERS_MAP, paramMap.toString()));
        }
        if (null != (ajaxParameter = paramMap.get(AJAX_PARAMETER_NAME))) {
            ((AjaxContainer)component).setAjaxRequest(true);
            if (ajaxParameter.equals(clientId)) {
                ((AjaxContainer)component).setSubmitted(true);
            }
        } else {
            ((AjaxContainer)component).setSubmitted(false);
            ((AjaxContainer)component).setAjaxRequest(false);
        }
    }
}

