/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.framework.ajax.AjaxContainerBase;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.ajax.AjaxRenderEvent;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxRegionBrige
implements AjaxContainerBase,
StateHolder {
    private static final Log log = LogFactory.getLog((Class)AjaxRegionBrige.class);
    private MethodBinding ajaxListener = null;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private boolean selfRendered = false;
    private boolean selfRenderedSet = false;
    private boolean transientFlag = false;
    private UIComponent component;

    public AjaxRegionBrige(UIComponent component) {
        this.component = component;
    }

    public MethodBinding getAjaxListener() {
        return this.ajaxListener;
    }

    public void setAjaxListener(MethodBinding ajaxListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SET_AJAX_LISTENER, ajaxListener.getExpressionString()));
        }
        this.ajaxListener = ajaxListener;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueBinding vb = this.component.getValueBinding("immediate");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(FacesContext.getCurrentInstance()));
        }
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        if (immediate != this.immediate) {
            this.immediate = immediate;
        }
        this.immediateSet = true;
    }

    public boolean isSelfRendered() {
        if (this.selfRenderedSet) {
            return this.selfRendered;
        }
        ValueBinding vb = this.component.getValueBinding("selfRendered");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(FacesContext.getCurrentInstance()));
        }
        return this.selfRendered;
    }

    public void setSelfRendered(boolean selfRendered) {
        this.selfRendered = selfRendered;
        this.selfRenderedSet = true;
    }

    public void addAjaxArea(String toRender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ADD_AJAX_AREA, toRender));
        }
        this.getAjaxAreasToRender().add(toRender);
    }

    public void addAjaxAreas(Collection collection) {
        if (log.isDebugEnabled()) {
            StringBuffer ids = new StringBuffer(Messages.getMessage(Messages.ADD_AJAX_AREAS));
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object id = iter.next();
                ids.append("|").append(id);
            }
            log.debug((Object)ids);
        }
        this.getAjaxAreasToRender().addAll(collection);
    }

    public Set getAjaxAreasToRender() {
        return AjaxContext.getCurrentInstance().getAjaxAreasToRender();
    }

    public Set getAjaxRenderedAreas() {
        return AjaxContext.getCurrentInstance().getAjaxRenderedAreas();
    }

    public boolean isAjaxRequest() {
        return AjaxContext.getCurrentInstance().isAjaxRequest();
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SET_AJAX_REQUEST, Boolean.toString(ajaxRequest)));
        }
        AjaxContext.getCurrentInstance().setAjaxRequest(ajaxRequest);
    }

    public boolean isSubmitted() {
        return this.component.getClientId(FacesContext.getCurrentInstance()).equals(AjaxContext.getCurrentInstance().getSubmittedRegionClientId());
    }

    public void setSubmitted(boolean submitted) {
        if (submitted && this.isAjaxRequest() && !this.isSubmitted()) {
            log.debug((Object)Messages.getMessage(Messages.SUBMITTED_AJAX_REQUEST));
            AjaxEvent event = new AjaxEvent(this.component);
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            }
            this.component.queueEvent((FacesEvent)event);
            AjaxContext.getCurrentInstance().setSubmittedRegionClientId(this.component.getClientId(FacesContext.getCurrentInstance()));
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof AjaxEvent) {
            MethodBinding mb;
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage(Messages.SEND_EVENT_TO_AJAX_LISTENER, this.component.getId()));
            }
            if ((mb = this.getAjaxListener()) != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                mb.invoke(context, new Object[]{event});
            }
            if (this.isSelfRendered()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Queue AjaxRenderEvent for self-render of  AjaxContainer with Id " + this.component.getId()));
                }
                AjaxRenderEvent renderEvent = new AjaxRenderEvent(this.component);
                renderEvent.setPhaseId(event.getPhaseId());
                this.component.queueEvent((FacesEvent)renderEvent);
            }
        }
        if (event instanceof AjaxRenderEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            AjaxContext.getCurrentInstance(context).renderAjaxRegion(context, this.component, false);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.RESTORE_AJAX_COMPONENT_STATE, this.component.getId()));
        }
        Object[] values = (Object[])state;
        this.immediate = (Boolean)values[0];
        this.immediateSet = (Boolean)values[1];
        this.ajaxListener = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.selfRendered = (Boolean)values[3];
        this.selfRenderedSet = (Boolean)values[4];
    }

    public Object saveState(FacesContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SAVE_AJAX_COMPONENT_STATE, this.component.getId()));
        }
        Object[] values = new Object[]{this.immediate, this.immediateSet, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.ajaxListener), this.selfRendered, this.selfRenderedSet};
        return values;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }
}

