/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component._AttachedListStateWrapper;
import javax.faces.component._AttachedStateWrapper;
import javax.faces.component._ComponentAttributesMap;
import javax.faces.component._ComponentChildrenList;
import javax.faces.component._ComponentFacetMap;
import javax.faces.component._ComponentUtils;
import javax.faces.component._FacetsAndChildrenIterator;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UIComponentBase
extends UIComponent {
    private static Log log = LogFactory.getLog((Class)(class$javax$faces$component$UIComponentBase == null ? (class$javax$faces$component$UIComponentBase = UIComponentBase.class$("javax.faces.component.UIComponentBase")) : class$javax$faces$component$UIComponentBase));
    private _ComponentAttributesMap _attributesMap = null;
    private Map _valueBindingMap = null;
    private List _childrenList = null;
    private Map _facetMap = null;
    private List _facesListeners = null;
    private String _clientId = null;
    private String _id = null;
    private UIComponent _parent = null;
    private boolean _transient = false;
    private static final boolean DEFAULT_RENDERED = true;
    private Boolean _rendered = null;
    private String _rendererType = null;
    static /* synthetic */ Class class$javax$faces$component$UIComponentBase;

    public Map getAttributes() {
        if (this._attributesMap == null) {
            this._attributesMap = new _ComponentAttributesMap(this);
        }
        return this._attributesMap;
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueBindingMap == null) {
            return null;
        }
        return (ValueBinding)this._valueBindingMap.get(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this._valueBindingMap == null) {
            this._valueBindingMap = new HashMap();
        }
        this._valueBindingMap.put(name, binding);
    }

    public String getClientId(FacesContext context) {
        UIComponent namingContainer;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._clientId != null) {
            return this._clientId;
        }
        boolean idWasNull = false;
        String id = this.getId();
        if (id == null) {
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot != null) {
                id = viewRoot.createUniqueId();
            } else {
                context.getExternalContext().log("ERROR: Cannot automatically create an id for component of type " + this.getClass().getName() + " because there is no viewRoot in the current facesContext!");
                id = "ERROR";
            }
            this.setId(id);
            idWasNull = true;
        }
        this._clientId = (namingContainer = _ComponentUtils.findParentNamingContainer(this, false)) != null ? namingContainer.getClientId(context) + ':' + id : id;
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            this._clientId = renderer.convertClientId(context, this._clientId);
        }
        if (idWasNull) {
            context.getExternalContext().log("WARNING: Component " + this._clientId + " just got an automatic id, because there was no id assigned yet. " + "If this component was created dynamically (i.e. not by a JSP tag) you should assign it an " + "explicit static id or assign it the id you get from the createUniqueId from the current UIViewRoot " + "component right after creation!");
        }
        return this._clientId;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this.isIdValid(id);
        this._id = id;
        this._clientId = null;
    }

    public UIComponent getParent() {
        return this._parent;
    }

    public void setParent(UIComponent parent) {
        this._parent = parent;
    }

    public boolean getRendersChildren() {
        Renderer renderer = this.getRenderer(this.getFacesContext());
        if (renderer != null) {
            return renderer.getRendersChildren();
        }
        return false;
    }

    public List getChildren() {
        if (this._childrenList == null) {
            this._childrenList = new _ComponentChildrenList(this);
        }
        return this._childrenList;
    }

    public int getChildCount() {
        return this._childrenList == null ? 0 : this._childrenList.size();
    }

    public UIComponent findComponent(String expr) {
        UIComponent findBase;
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (expr.length() == 0) {
            throw new IllegalArgumentException("empty expr");
        }
        if (expr.charAt(0) == ':') {
            findBase = _ComponentUtils.getRootComponent(this);
            expr = expr.substring(1);
        } else {
            findBase = this instanceof NamingContainer ? this : _ComponentUtils.findParentNamingContainer(this, true);
        }
        int separator = expr.indexOf(58);
        if (separator == -1) {
            return _ComponentUtils.findComponent(findBase, expr);
        }
        String id = expr.substring(0, separator);
        if ((findBase = _ComponentUtils.findComponent(findBase, id)) == null) {
            return null;
        }
        if (!(findBase instanceof NamingContainer)) {
            throw new IllegalArgumentException("Intermediate identifier " + id + " in search expression " + expr + " identifies a UIComponent that is not a NamingContainer");
        }
        return findBase.findComponent(expr.substring(separator + 1));
    }

    public Map getFacets() {
        if (this._facetMap == null) {
            this._facetMap = new _ComponentFacetMap(this);
        }
        return this._facetMap;
    }

    public UIComponent getFacet(String name) {
        return this._facetMap == null ? null : (UIComponent)this._facetMap.get(name);
    }

    public Iterator getFacetsAndChildren() {
        return new _FacetsAndChildrenIterator(this._facetMap, this._childrenList);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this._facesListeners == null) {
            return;
        }
        Iterator it = this._facesListeners.iterator();
        while (it.hasNext()) {
            FacesListener facesListener = (FacesListener)it.next();
            if (!event.isAppropriateListener(facesListener)) continue;
            event.processListener(facesListener);
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, this);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeBegin(context, this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeChildren(context, this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeEnd(context, this);
        }
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._facesListeners == null) {
            this._facesListeners = new ArrayList();
        }
        this._facesListeners.add(listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        if (this._facesListeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> lst = null;
        Iterator it = this._facesListeners.iterator();
        while (it.hasNext()) {
            FacesListener facesListener = (FacesListener)it.next();
            if (!clazz.isAssignableFrom(facesListener.getClass())) continue;
            if (lst == null) {
                lst = new ArrayList<FacesListener>();
            }
            lst.add(facesListener);
        }
        if (lst == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        return lst.toArray((FacesListener[])Array.newInstance(clazz, lst.size()));
    }

    protected void removeFacesListener(FacesListener listener) {
        if (this._facesListeners != null) {
            this._facesListeners.remove(listener);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("component is not a descendant of a UIViewRoot");
        }
        parent.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = (UIComponent)it.next();
            childOrFacet.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = (UIComponent)it.next();
            childOrFacet.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = (UIComponent)it.next();
            childOrFacet.processUpdates(context);
        }
    }

    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.isTransient()) {
            return null;
        }
        HashMap facetMap = null;
        Iterator it = this.getFacets().entrySet().iterator();
        while (it.hasNext()) {
            UIComponent component;
            Map.Entry entry = it.next();
            if (facetMap == null) {
                facetMap = new HashMap();
            }
            if ((component = (UIComponent)entry.getValue()).isTransient()) continue;
            facetMap.put(entry.getKey(), component.processSaveState(context));
        }
        ArrayList<Object> childrenList = null;
        if (this.getChildCount() > 0) {
            Iterator it2 = this.getChildren().iterator();
            while (it2.hasNext()) {
                Object childState;
                UIComponent child = (UIComponent)it2.next();
                if (childrenList == null) {
                    childrenList = new ArrayList<Object>(this.getChildCount());
                }
                if ((childState = child.processSaveState(context)) == null) continue;
                childrenList.add(childState);
            }
        }
        return new Object[]{this.saveState(context), facetMap, childrenList};
    }

    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Object myState = ((Object[])state)[0];
        Map facetMap = (Map)((Object[])state)[1];
        List childrenList = (List)((Object[])state)[2];
        if (facetMap != null) {
            Iterator it = this.getFacets().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object facetState = facetMap.get(entry.getKey());
                if (facetState != null) {
                    UIComponent component = (UIComponent)entry.getValue();
                    component.processRestoreState(context, facetState);
                    continue;
                }
                context.getExternalContext().log("No state found to restore facet " + entry.getKey());
            }
        }
        if (childrenList != null && this.getChildCount() > 0) {
            int idx = 0;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                Object childState;
                UIComponent child = (UIComponent)it.next();
                if (child.isTransient()) continue;
                if ((childState = childrenList.get(idx++)) != null) {
                    child.processRestoreState(context, childState);
                    continue;
                }
                context.getExternalContext().log("No state found to restore child of component " + this.getId());
            }
        }
        this.restoreState(context, myState);
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Renderer getRenderer(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = this.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        Renderer renderer = renderKit.getRenderer(this.getFamily(), rendererType);
        if (renderer == null) {
            this.getFacesContext().getExternalContext().log("No Renderer found for component " + this.getPathToComponent(this) + " (component-family=" + this.getFamily() + ", renderer-type=" + rendererType + ")");
            log.warn((Object)("No Renderer found for component " + this.getPathToComponent(this) + " (component-family=" + this.getFamily() + ", renderer-type=" + rendererType + ")"));
        }
        return renderer;
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        UIComponentBase.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, (Object)intBuf);
        if (component != null) {
            UIComponentBase.getPathToComponent(component.getParent(), buf);
        }
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transientFlag) {
        this._transient = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (attachedObject == null) {
            return null;
        }
        if (attachedObject instanceof List) {
            ArrayList<Object> lst = new ArrayList<Object>(((List)attachedObject).size());
            Iterator it = ((List)attachedObject).iterator();
            while (it.hasNext()) {
                lst.add(UIComponentBase.saveAttachedState(context, it.next()));
            }
            return new _AttachedListStateWrapper(lst);
        }
        if (attachedObject instanceof StateHolder) {
            if (((StateHolder)attachedObject).isTransient()) {
                return null;
            }
            return new _AttachedStateWrapper(attachedObject.getClass(), ((StateHolder)attachedObject).saveState(context));
        }
        if (attachedObject instanceof Serializable) {
            return attachedObject;
        }
        return new _AttachedStateWrapper(attachedObject.getClass(), null);
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (stateObj == null) {
            return null;
        }
        if (stateObj instanceof _AttachedListStateWrapper) {
            List lst = ((_AttachedListStateWrapper)stateObj).getWrappedStateList();
            ArrayList<Object> restoredList = new ArrayList<Object>(lst.size());
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                restoredList.add(UIComponentBase.restoreAttachedState(context, it.next()));
            }
            return restoredList;
        }
        if (stateObj instanceof _AttachedStateWrapper) {
            Class clazz = ((_AttachedStateWrapper)stateObj).getClazz();
            Object restoredObject = null;
            try {
                restoredObject = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not restore StateHolder of type " + clazz.getName() + " (missing no-args constructor?)", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (restoredObject instanceof StateHolder) {
                Object wrappedState = ((_AttachedStateWrapper)stateObj).getWrappedStateObject();
                ((StateHolder)restoredObject).restoreState(context, wrappedState);
            }
            return restoredObject;
        }
        return stateObj;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this._id, this._rendered, this._rendererType, this._clientId, this.saveAttributesMap(), UIComponentBase.saveAttachedState(context, this._facesListeners), this.saveValueBindingMap(context)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._id = (String)values[0];
        this._rendered = (Boolean)values[1];
        this._rendererType = (String)values[2];
        this._clientId = (String)values[3];
        this.restoreAttributesMap(values[4]);
        this._facesListeners = (List)UIComponentBase.restoreAttachedState(context, values[5]);
        this.restoreValueBindingMap(context, values[6]);
    }

    private Object saveAttributesMap() {
        if (this._attributesMap != null) {
            return this._attributesMap.getUnderlyingMap();
        }
        return null;
    }

    private void restoreAttributesMap(Object stateObj) {
        this._attributesMap = stateObj != null ? new _ComponentAttributesMap(this, (Map)stateObj) : null;
    }

    private Object saveValueBindingMap(FacesContext context) {
        if (this._valueBindingMap != null) {
            int initCapacity = (this._valueBindingMap.size() * 4 + 3) / 3;
            HashMap stateMap = new HashMap(initCapacity);
            Iterator it = this._valueBindingMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                stateMap.put(entry.getKey(), UIComponentBase.saveAttachedState(context, entry.getValue()));
            }
            return stateMap;
        }
        return null;
    }

    private void restoreValueBindingMap(FacesContext context, Object stateObj) {
        if (stateObj != null) {
            Map stateMap = (Map)stateObj;
            int initCapacity = (stateMap.size() * 4 + 3) / 3;
            this._valueBindingMap = new HashMap(initCapacity);
            Iterator it = stateMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this._valueBindingMap.put(entry.getKey(), UIComponentBase.restoreAttachedState(context, entry.getValue()));
            }
        } else {
            this._valueBindingMap = null;
        }
    }

    private void isIdValid(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("component identifier must not be a zero-length String");
        }
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char tmpChar = chars[i];
            if (i == 0) {
                if (Character.isLetter(tmpChar) || tmpChar == '_') continue;
                throw new IllegalArgumentException("component identifier's first character must be a letter or an underscore ('_')! But it is \"" + tmpChar + "\"");
            }
            if (Character.isDigit(tmpChar) || Character.isLetter(tmpChar) || tmpChar == '-' || tmpChar == '_') continue;
            throw new IllegalArgumentException("Subsequent characters of component identifier must be a letter, a digit, an underscore ('_'), or a dash ('-')! But component identifier contains \"" + tmpChar + "\"");
        }
    }

    public void setRendered(boolean rendered) {
        this._rendered = rendered;
    }

    public boolean isRendered() {
        if (this._rendered != null) {
            return this._rendered;
        }
        ValueBinding vb = this.getValueBinding("rendered");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setRendererType(String rendererType) {
        this._rendererType = rendererType;
    }

    public String getRendererType() {
        if (this._rendererType != null) {
            return this._rendererType;
        }
        ValueBinding vb = this.getValueBinding("rendererType");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

