/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.security.Ejb3AuthenticationInterceptor;
import org.jboss.security.AuthenticationManager;

public class AuthenticationInterceptorFactory
implements AspectFactory {
    public Object createPerVM() {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerClass(Advisor advisor) {
        Object domain = null;
        try {
            Container container = (Container)advisor;
            InitialContext ctx = container.getInitialContext();
            SecurityDomain securityAnnotation = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (securityAnnotation != null) {
                domain = ctx.lookup("java:/jaas/" + securityAnnotation.value());
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        AuthenticationManager manager = (AuthenticationManager)domain;
        return new Ejb3AuthenticationInterceptor(manager);
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public String getName() {
        return this.getClass().getName();
    }
}

