/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.jboss.logging.Logger;
import org.xml.sax.InputSource;

public class WSDL11DefinitionFactory {
    private static Logger log = Logger.getLogger(WSDL11DefinitionFactory.class);
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private WSDLReader wsdlReader;

    private WSDL11DefinitionFactory() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        this.wsdlReader = wsdlFactory.newWSDLReader();
        this.wsdlReader.setFeature(FEATURE_VERBOSE, false);
    }

    public static WSDL11DefinitionFactory newInstance() throws WSDLException {
        return new WSDL11DefinitionFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.wsdlReader.setFeature(name, value);
    }

    public Definition parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        Definition wsdlDefinition = this.wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl(wsdlLocation));
        return wsdlDefinition;
    }

    public static class WSDLLocatorImpl
    implements WSDLLocator {
        private URL wsdlURL;
        private String latestImportURI;

        public WSDLLocatorImpl(URL wsdlFile) {
            if (wsdlFile == null) {
                throw new IllegalArgumentException("WSDL file argument cannot be null");
            }
            this.wsdlURL = wsdlFile;
        }

        public InputSource getBaseInputSource() {
            log.debug((Object)("getBaseInputSource [wsdlUrl=" + this.wsdlURL + "]"));
            try {
                InputStream is = this.wsdlURL.openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlURL + "]");
                }
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access wsdl from [" + this.wsdlURL + "], " + e.getMessage());
            }
        }

        public String getBaseURI() {
            return this.wsdlURL.toExternalForm();
        }

        public InputSource getImportInputSource(String parent, String resource) {
            log.debug((Object)("getImportInputSource [parent=" + parent + ",resource=" + resource + "]"));
            URL parentURL = null;
            try {
                parentURL = new URL(parent);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Not a valid URL: " + parent));
                return null;
            }
            String wsdlImport = null;
            String external = parentURL.toExternalForm();
            if (resource.startsWith("http://") || resource.startsWith("https://")) {
                wsdlImport = resource;
            } else if (resource.startsWith("/")) {
                String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
                wsdlImport = beforePath + resource;
            } else {
                String parentDir = external.substring(0, external.lastIndexOf("/"));
                while (resource.startsWith("./")) {
                    resource = resource.substring(2);
                }
                while (resource.startsWith("../")) {
                    parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                    resource = resource.substring(3);
                }
                wsdlImport = parentDir + "/" + resource;
            }
            try {
                log.debug((Object)("Resolved to: " + wsdlImport));
                InputStream is = new URL(wsdlImport).openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot import wsdl from [" + wsdlImport + "]");
                }
                this.latestImportURI = wsdlImport;
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
            }
        }

        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }
}

