/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.serviceref;

import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.rpc.JAXRPCException;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.webservice.metadata.serviceref.ServiceRefMetaData;
import org.w3c.dom.Element;

public class PortComponentRefMetaData
implements Serializable {
    static final long serialVersionUID = 3856598615591044263L;
    private ServiceRefMetaData serviceRefMetaData;
    private String serviceEndpointInterface;
    private String portComponentLink;
    private Properties callProperties;

    public PortComponentRefMetaData(ServiceRefMetaData serviceRefMetaData) {
        this.serviceRefMetaData = serviceRefMetaData;
    }

    public ServiceRefMetaData getServiceRefMetaData() {
        return this.serviceRefMetaData;
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public Class getServiceEndpointInterfaceClass() {
        try {
            URLClassLoader cl = this.serviceRefMetaData.getResourceCL();
            return cl.loadClass(this.serviceEndpointInterface);
        }
        catch (ClassNotFoundException e) {
            throw new JAXRPCException("Cannot load service endpoint interface: " + this.serviceEndpointInterface);
        }
    }

    public Properties getCallProperties() {
        return this.callProperties;
    }

    public void importStandardXml(Element element) throws DeploymentException {
        this.serviceEndpointInterface = MetaData.getUniqueChildContent(element, "service-endpoint-interface");
        this.portComponentLink = MetaData.getOptionalChildContent(element, "port-component-link");
    }

    public void importJBossXml(Element element) throws DeploymentException {
        Iterator iterator = MetaData.getChildrenByTagName(element, "call-property");
        while (iterator.hasNext()) {
            Element propElement = (Element)iterator.next();
            String name = MetaData.getUniqueChildContent(propElement, "prop-name");
            String value = MetaData.getUniqueChildContent(propElement, "prop-value");
            if (this.callProperties == null) {
                this.callProperties = new Properties();
            }
            this.callProperties.setProperty(name, value);
        }
    }
}

