/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.strategy.EJBVerifier20;
import org.jboss.verifier.strategy.VerificationContext;

public class EJBVerifier21
extends EJBVerifier20 {
    protected Class serviceEndpointInterface;

    public EJBVerifier21(VerificationContext context) {
        super(context);
    }

    public void checkSession(SessionMetaData session) {
        boolean localOrRemoteExists = false;
        boolean verified = false;
        if (!this.verifyBean(session)) {
            return;
        }
        verified = this.verifySessionBean(session);
        if (this.hasRemoteInterfaces(session)) {
            localOrRemoteExists = true;
            verified = verified && this.verifySessionRemote(session);
            boolean bl = verified = verified && this.verifySessionHome(session);
        }
        if (this.hasLocalInterfaces(session)) {
            localOrRemoteExists = true;
            verified = verified && this.verifySessionLocal(session);
            boolean bl = verified = verified && this.verifySessionLocalHome(session);
        }
        if (this.hasServiceEndpointInterfaces(session)) {
            localOrRemoteExists = true;
            boolean bl = verified = verified && this.verifyServiceEndpoint(session);
        }
        if (!localOrRemoteExists) {
            this.fireSpecViolationEvent(session, new Section("7.11.1.x"));
            verified = false;
        }
        if (verified) {
            this.fireBeanVerifiedEvent(session);
        }
    }

    protected boolean verifyMessageDrivenBean(MessageDrivenMetaData mdBean) {
        boolean status = true;
        if (!this.hasMessageDrivenBeanInterface(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.a"));
            status = false;
        }
        if (!this.isAssignableFrom(mdBean.getMessagingType(), this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.b"));
            status = false;
        }
        if (!this.isPublic(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.c1"));
            status = false;
        }
        if (this.isFinal(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.c2"));
            status = false;
        }
        if (this.isAbstract(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.c3"));
            status = false;
        }
        if (!this.hasDefaultConstructor(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.d"));
            status = false;
        }
        if (this.hasFinalizer(this.bean)) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.e"));
            status = false;
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            Iterator it = this.getEJBCreateMethods(this.bean);
            Method ejbCreate = (Method)it.next();
            if (!this.isPublic(ejbCreate)) {
                this.fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.b"));
                status = false;
            }
            if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                this.fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.c"));
                status = false;
            }
            if (!this.hasVoidReturnType(ejbCreate)) {
                this.fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.d"));
                status = false;
            }
            if (!this.hasNoArguments(ejbCreate)) {
                this.fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.e"));
                status = false;
            }
            if (!this.throwsNoException(ejbCreate)) {
                this.fireSpecViolationEvent(mdBean, ejbCreate, new Section("15.7.3.f"));
                status = false;
            }
            if (it.hasNext()) {
                this.fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
                status = false;
            }
        } else {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.3.a"));
            status = false;
        }
        Class<?> messageListener = null;
        try {
            messageListener = this.classloader.loadClass(mdBean.getMessagingType());
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.2.b", "Class not found on '" + mdBean.getMessagingType() + "': " + cnfe.getMessage()));
            status = false;
        }
        if (messageListener != null) {
            Method[] methods = this.bean.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().equals(messageListener)) continue;
                if (!this.isPublic(methods[i])) {
                    this.fireSpecViolationEvent(mdBean, methods[i], new Section("15.7.4.b"));
                    status = false;
                }
                if (!this.isFinal(methods[i]) && !this.isStatic(methods[i])) continue;
                this.fireSpecViolationEvent(mdBean, methods[i], new Section("15.7.4.c"));
                status = false;
            }
        }
        if (this.hasEJBRemoveMethod(this.bean)) {
            Iterator it = this.getEJBRemoveMethods(this.bean);
            Method ejbRemove = (Method)it.next();
            if (!this.isPublic(ejbRemove)) {
                this.fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.b"));
                status = false;
            }
            if (this.isFinal(ejbRemove) || this.isStatic(ejbRemove)) {
                this.fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.c"));
                status = false;
            }
            if (!this.hasVoidReturnType(ejbRemove)) {
                this.fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.d"));
                status = false;
            }
            if (!this.hasNoArguments(ejbRemove)) {
                this.fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.e"));
                status = false;
            }
            if (!this.throwsNoException(ejbRemove)) {
                this.fireSpecViolationEvent(mdBean, ejbRemove, new Section("15.7.5.f"));
                status = false;
            }
            if (it.hasNext()) {
                this.fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
                status = false;
            }
        } else {
            this.fireSpecViolationEvent(mdBean, new Section("15.7.5.a"));
            status = false;
        }
        return status;
    }

    public boolean hasRemoteInterface(Class c) {
        return this.isAssignableFrom("java.rmi.Remote", c);
    }

    protected boolean verifyServiceEndpoint(SessionMetaData session) {
        boolean status = true;
        if (!this.hasRemoteInterface(this.serviceEndpointInterface)) {
            this.fireSpecViolationEvent(session, new Section("7.11.9.x"));
            status = false;
        }
        for (Method method : Arrays.asList(this.serviceEndpointInterface.getMethods())) {
            if (!this.hasLegalJAXRPCArguments(method)) {
                this.fireSpecViolationEvent(session, method, new Section("7.11.9.x"));
                status = false;
            }
            if (!this.hasLegalJAXRPCReturnType(method)) {
                this.fireSpecViolationEvent(session, method, new Section("7.11.9.x"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent(session, method, new Section("7.11.9.x"));
            status = false;
        }
        for (Method remoteMethod : Arrays.asList(this.serviceEndpointInterface.getDeclaredMethods())) {
            if (!this.hasMatchingMethod(this.bean, remoteMethod)) {
                this.fireSpecViolationEvent(session, remoteMethod, new Section("7.11.9.x"));
                status = false;
                continue;
            }
            try {
                Method beanMethod = this.bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
                if (!this.hasMatchingReturnType(remoteMethod, beanMethod)) {
                    this.fireSpecViolationEvent(session, remoteMethod, new Section("7.11.9.x"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, remoteMethod)) continue;
                this.fireSpecViolationEvent(session, remoteMethod, new Section("7.11.59.x"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    protected boolean hasLegalJAXRPCReturnType(Method method) {
        return this.isJAXRPCType(method.getReturnType());
    }

    protected boolean isJAXRPCType(Class class1) {
        return this.isRMIIDLValueType(class1);
    }

    protected boolean hasLegalJAXRPCArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (this.isJAXRPCType(params[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean hasServiceEndpointInterfaces(SessionMetaData bean) {
        boolean status = true;
        String seiName = bean.getServiceEndpoint();
        if (seiName == null) {
            return false;
        }
        try {
            this.serviceEndpointInterface = this.classloader.loadClass(seiName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(bean, new Section("23.2", "Class not found on '" + seiName + "': " + cnfe.getMessage()));
            status = false;
        }
        return status;
    }
}

