/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.LinkedList;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream;
import org.jboss.invocation.pooled.server.LRUPool;
import org.jboss.invocation.pooled.server.PooledInvoker;
import org.jboss.logging.Logger;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger(ServerThread.class);
    protected ObjectInputStream in;
    protected ObjectOutputStream out;
    protected Socket socket;
    protected PooledInvoker invoker;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected volatile boolean running = true;
    protected volatile boolean handlingResponse = true;
    protected volatile boolean shutdown = false;
    protected static int id = 0;

    public static synchronized int nextID() {
        int nextID = id++;
        return nextID;
    }

    public ServerThread(Socket socket, PooledInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout) throws Exception {
        super("PooledInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID());
        this.socket = socket;
        this.invoker = invoker;
        this.clientpool = clientpool;
        this.threadpool = threadpool;
        socket.setSoTimeout(timeout);
    }

    public void shutdown() {
        this.shutdown = true;
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void evict() {
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void wakeup(Socket socket, int timeout) throws Exception {
        this.socket = socket;
        String name = "PooledInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID();
        super.setName(name);
        socket.setSoTimeout(timeout);
        this.running = true;
        this.handlingResponse = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                this.dorun();
                if (this.shutdown) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        this.clientpool.remove(this);
                        return;
                    }
                }
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        LinkedList linkedList = this.threadpool;
                        synchronized (linkedList) {
                            this.clientpool.remove(this);
                            this.threadpool.add(this);
                            Thread.interrupted();
                            ((Object)((Object)this.clientpool)).notify();
                        }
                    }
                    log.debug((Object)"begin thread wait");
                    this.wait();
                    log.debug((Object)"WAKEUP in SERVER THREAD");
                }
            }
        }
        catch (Exception exception) {
            log.debug((Object)"Exiting run on exception", (Throwable)exception);
            return;
        }
    }

    protected void acknowledge() throws Exception {
        byte ACK = this.in.readByte();
        this.handlingResponse = true;
        this.out.writeByte(ACK);
        this.out.flush();
    }

    protected void processInvocation() throws Exception {
        this.handlingResponse = true;
        Invocation invocation = (Invocation)this.in.readObject();
        this.in.readObject();
        Object response = null;
        try {
            boolean interrupted = Thread.interrupted();
            response = this.invoker.invoke(invocation);
        }
        catch (Exception ex) {
            response = ex;
        }
        Thread.interrupted();
        this.out.writeObject(response);
        this.out.reset();
        this.out.writeObject(Boolean.TRUE);
        this.out.flush();
        this.out.reset();
        this.handlingResponse = false;
    }

    protected void dorun() {
        log.debug((Object)"beginning dorun");
        this.running = true;
        this.handlingResponse = true;
        try {
            BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream());
            this.out = new OptimizedObjectOutputStream(bos);
            this.out.flush();
            BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream());
            this.in = new OptimizedObjectInputStream(bis);
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize", (Throwable)e);
        }
        try {
            this.processInvocation();
        }
        catch (Exception ex) {
            this.running = false;
        }
        while (this.running) {
            try {
                this.acknowledge();
                this.processInvocation();
            }
            catch (InterruptedIOException e) {
                log.debug((Object)"socket timed out", (Throwable)e);
                this.running = false;
            }
            catch (InterruptedException e) {
                log.debug((Object)"interrupted", (Throwable)e);
            }
            catch (Exception ex) {
                log.debug((Object)"failed", (Throwable)ex);
                this.running = false;
            }
            Thread.interrupted();
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed cleanup", (Throwable)ex);
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }
}

