/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.http.interfaces.ClientMethodInterceptor;
import org.jboss.invocation.http.interfaces.HttpInvokerProxy;
import org.jboss.invocation.http.server.HttpProxyFactoryMBean;
import org.jboss.metadata.MetaData;
import org.jboss.naming.Util;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;

public class HttpProxyFactory
extends ServiceMBeanSupport
implements HttpProxyFactoryMBean {
    private ObjectName jmxInvokerName;
    private Object theProxy;
    private String invokerURL;
    private String invokerURLPrefix = "http://";
    private String invokerURLSuffix = ":8080/invoker/JMXInvokerServlet";
    private boolean useHostName = false;
    private String jndiName;
    private Class exportedInterface;
    private Element interceptorConfig;
    private ArrayList interceptorClasses;

    public ObjectName getInvokerName() {
        return this.jmxInvokerName;
    }

    public void setInvokerName(ObjectName jmxInvokerName) {
        this.jmxInvokerName = jmxInvokerName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getInvokerURL() {
        return this.invokerURL;
    }

    public void setInvokerURL(String invokerURL) {
        String tmp;
        this.invokerURL = tmp = StringPropertyReplacer.replaceProperties((String)invokerURL);
        this.log.debug((Object)("Set invokerURL to " + this.invokerURL));
    }

    public String getInvokerURLPrefix() {
        return this.invokerURLPrefix;
    }

    public void setInvokerURLPrefix(String invokerURLPrefix) {
        this.invokerURLPrefix = invokerURLPrefix;
    }

    public String getInvokerURLSuffix() {
        return this.invokerURLSuffix;
    }

    public void setInvokerURLSuffix(String invokerURLSuffix) {
        this.invokerURLSuffix = invokerURLSuffix;
    }

    public boolean getUseHostName() {
        return this.useHostName;
    }

    public void setUseHostName(boolean flag) {
        this.useHostName = flag;
    }

    public Class getExportedInterface() {
        return this.exportedInterface;
    }

    public void setExportedInterface(Class exportedInterface) {
        this.exportedInterface = exportedInterface;
    }

    public Element getClientInterceptors() {
        return this.interceptorConfig;
    }

    public void setClientInterceptors(Element config) throws Exception {
        this.interceptorConfig = config;
        Iterator interceptorElements = MetaData.getChildrenByTagName(this.interceptorConfig, "interceptor");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.interceptorClasses != null) {
            this.interceptorClasses.clear();
        } else {
            this.interceptorClasses = new ArrayList();
        }
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Element ielement = (Element)interceptorElements.next();
            String className = null;
            className = MetaData.getElementContent(ielement);
            Class<?> clazz = loader.loadClass(className);
            this.interceptorClasses.add(clazz);
        }
    }

    public Object getProxy() {
        return this.theProxy;
    }

    public Object getProxy(Object id) {
        Class[] ifaces = new Class[]{this.exportedInterface};
        Object interceptorClasses = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object newProxy = null;
        return newProxy;
    }

    protected void startService() throws Exception {
        Invoker delegateInvoker = this.createInvoker();
        Integer nameHash = new Integer(this.jmxInvokerName.hashCode());
        this.log.debug((Object)("Bound delegate: " + delegateInvoker + " for invoker=" + this.jmxInvokerName));
        Registry.bind((Object)nameHash, (Object)this.jmxInvokerName);
        Object cacheID = null;
        String proxyBindingName = null;
        Class[] ifaces = new Class[]{this.exportedInterface};
        if (this.interceptorClasses == null) {
            this.interceptorClasses = this.defineDefaultInterceptors();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, this.jmxInvokerName, delegateInvoker, this.jndiName, proxyBindingName, this.interceptorClasses, loader, ifaces);
        this.log.debug((Object)("Created HttpInvokerProxy for invoker=" + this.jmxInvokerName + ", nameHash=" + nameHash));
        if (this.jndiName != null) {
            InitialContext iniCtx = new InitialContext();
            Util.bind((Context)iniCtx, (String)this.jndiName, (Object)this.theProxy);
            this.log.debug((Object)("Bound proxy under jndiName=" + this.jndiName));
        }
    }

    protected void stopService() throws Exception {
        Integer nameHash = new Integer(this.jmxInvokerName.hashCode());
        Registry.unbind((Object)this.jmxInvokerName);
        Registry.unbind((Object)nameHash);
        if (this.jndiName != null) {
            InitialContext iniCtx = new InitialContext();
            Util.unbind((Context)iniCtx, (String)this.jndiName);
        }
    }

    protected ArrayList defineDefaultInterceptors() {
        ArrayList<Class> tmp = new ArrayList<Class>();
        tmp.add(ClientMethodInterceptor.class);
        tmp.add(InvokerInterceptor.class);
        return tmp;
    }

    protected Invoker createInvoker() throws Exception {
        this.checkInvokerURL();
        HttpInvokerProxy delegateInvoker = new HttpInvokerProxy(this.invokerURL);
        return delegateInvoker;
    }

    protected void checkInvokerURL() throws UnknownHostException {
        if (this.invokerURL == null) {
            String host = ServerConfigUtil.getSpecificBindAddress();
            if (host == null) {
                InetAddress addr = InetAddress.getLocalHost();
                host = this.useHostName ? addr.getHostName() : addr.getHostAddress();
            }
            String url = this.invokerURLPrefix + host + this.invokerURLSuffix;
            this.setInvokerURL(url);
        }
    }
}

