/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.txtimer.DatabasePersistencePlugin;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.util.ObjectNameFactory;

public class GeneralPurposeDatabasePersistencePlugin
implements DatabasePersistencePlugin {
    private static Logger log = Logger.getLogger(GeneralPurposeDatabasePersistencePlugin.class);
    protected ObjectName dataSourceName;
    protected MBeanServer server;
    protected DataSource ds;
    protected ObjectName metaDataName;

    public void init(MBeanServer server, ObjectName dataSourceName) throws SQLException {
        this.server = server;
        this.dataSourceName = dataSourceName;
        try {
            String dsJndiTx = (String)server.getAttribute(dataSourceName, "BindName");
            this.ds = (DataSource)new InitialContext().lookup(dsJndiTx);
        }
        catch (Exception e) {
            throw new SQLException("Failed to lookup data source: " + dataSourceName);
        }
        String dsName = dataSourceName.getKeyProperty("name");
        this.metaDataName = ObjectNameFactory.create((String)("jboss.jdbc:datasource=" + dsName + ",service=metadata"));
        if (!this.server.isRegistered(this.metaDataName)) {
            throw new IllegalStateException("Cannot find datasource meta data: " + this.metaDataName);
        }
    }

    /*
     * Exception decompiling
     */
    public void createTableIfNotExists() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = this.ds.getConnection();
            String sql = "insert into " + this.getTableName() + " " + "(" + this.getColumnTimerID() + "," + this.getColumnTargetID() + "," + this.getColumnInitialDate() + "," + this.getColumnTimerInterval() + "," + this.getColumnInstancePK() + "," + this.getColumnInfo() + ") " + "values (?,?,?,?,?,?)";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
            st.setLong(4, intervalDuration);
            st.setBytes(5, this.serialize(timedObjectId.getInstancePk()));
            st.setBytes(6, this.serialize(info));
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.error((Object)("Unable to insert timer for: " + timedObjectId));
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTimers(ObjectName containerId) throws SQLException {
        ArrayList<TimerHandleImpl> arrayList;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            ArrayList<TimerHandleImpl> list = new ArrayList<TimerHandleImpl>();
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.getTableName());
            while (rs.next()) {
                String timerId = rs.getString(this.getColumnTimerID());
                TimedObjectId targetId = TimedObjectId.parse(rs.getString(this.getColumnTargetID()));
                if (containerId != null && !containerId.equals(targetId.getContainerId())) continue;
                Timestamp initialDate = rs.getTimestamp(this.getColumnInitialDate());
                long interval = rs.getLong(this.getColumnTimerInterval());
                Serializable pKey = (Serializable)this.deserialize(rs.getBytes(this.getColumnInstancePK()));
                Serializable info = null;
                try {
                    info = (Serializable)this.deserialize(rs.getBytes(this.getColumnInfo()));
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot deserialize custom info object", (Throwable)e);
                }
                targetId = new TimedObjectId(targetId.getContainerId(), pKey);
                TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, interval, info);
                list.add(handle);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTimer(String timerId, TimedObjectId timedObjectId) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            String sql = "delete from " + this.getTableName() + " where " + this.getColumnTimerID() + "=? and " + this.getColumnTargetID() + "=?";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.debug((Object)("Unable to remove timer for: " + timerId));
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimers() throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            st = con.prepareStatement("delete from " + this.getTableName());
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    public String getTableName() {
        return "TIMERS";
    }

    public String getColumnTimerID() {
        return "TIMERID";
    }

    public String getColumnTargetID() {
        return "TARGETID";
    }

    public String getColumnInitialDate() {
        return "INITIALDATE";
    }

    public String getColumnTimerInterval() {
        return "TIMERINTERVAL";
    }

    public String getColumnInstancePK() {
        return "INSTANCEPK";
    }

    public String getColumnInfo() {
        return "INFO";
    }

    protected byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            log.error((Object)("Cannot serialize: " + obj), (Throwable)e);
        }
        return baos.toByteArray();
    }

    protected Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            MarshalledValueInputStream oos = new MarshalledValueInputStream(bais);
            return oos.readObject();
        }
        catch (Exception e) {
            log.error((Object)"Cannot deserialize", (Throwable)e);
            return null;
        }
    }

    protected Object deserialize(InputStream input) {
        if (input == null) {
            return null;
        }
        byte[] barr = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            int b = 0;
            while ((b = input.read(barr)) > 0) {
                baos.write(barr, 0, b);
            }
            return this.deserialize(baos.toByteArray());
        }
        catch (Exception e) {
            log.error((Object)"Cannot deserialize", (Throwable)e);
            return null;
        }
    }
}

