/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.logging.Logger;

public abstract class AbstractQueryCommand
implements QueryCommand {
    static final CollectionFactory COLLECTION_FACTORY = new CollectionFactory(){

        public Collection newCollection() {
            return new ArrayList();
        }
    };
    static final CollectionFactory SET_FACTORY = new CollectionFactory(){

        public Collection newCollection() {
            return new HashSet();
        }
    };
    protected String sql;
    protected Logger log;
    protected JDBCEntityBridge2 entity;
    protected QueryParameter[] params = null;
    private CollectionFactory collectionFactory;
    private CollectionStrategy collectionStrategy;
    private ResultReader resultReader;

    protected void setResultType(Class clazz) {
        if (Set.class.isAssignableFrom(clazz)) {
            this.collectionFactory = SET_FACTORY;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.collectionFactory = COLLECTION_FACTORY;
        }
        this.initCollectionStrategy();
    }

    protected void setFieldReader(JDBCCMPFieldBridge2 field) {
        this.resultReader = new FieldReader(field);
        this.initCollectionStrategy();
    }

    protected void setFunctionReader(SelectFunction func) {
        this.resultReader = new FunctionReader(func);
        this.initCollectionStrategy();
    }

    protected void setEntityReader(JDBCEntityBridge2 entity) {
        this.entity = entity;
        this.resultReader = new EntityReader(entity);
        this.initCollectionStrategy();
    }

    private void initCollectionStrategy() {
        if (this.collectionFactory != null && this.resultReader != null) {
            this.collectionStrategy = new EagerCollectionStrategy(this.collectionFactory, this.resultReader, this.log);
        }
    }

    public JDBCStoreManager2 getStoreManager() {
        return (JDBCStoreManager2)this.entity.getManager();
    }

    public Collection fetchCollection(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException {
        return AbstractQueryCommand.fetchCollection(this.entity, this.sql, this.params, this.collectionStrategy, schema, factory, args, this.log);
    }

    public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException {
        schema.flush();
        return this.executeFetchOne(args, factory);
    }

    protected Object executeFetchOne(Object[] args, GenericEntityObjectFactory factory) throws FinderException {
        return AbstractQueryCommand.fetchOne(this.entity, this.sql, this.params, this.resultReader, args, factory, this.log);
    }

    static Collection fetchCollection(JDBCEntityBridge2 entity, String sql, QueryParameter[] params, CollectionStrategy collectionStrategy, Schema schema, GenericEntityObjectFactory factory, Object[] args, Logger log) throws FinderException {
        schema.flush();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean throwRuntimeExceptions = entity.getMetaData().getThrowRuntimeExceptions();
        if (throwRuntimeExceptions) {
            try {
                con = entity.getDataSource().getConnection();
            }
            catch (SQLException sqle) {
                EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
                ejbe.initCause((Throwable)sqle);
                throw ejbe;
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing: " + sql));
            }
            if (!throwRuntimeExceptions) {
                con = entity.getDataSource().getConnection();
            }
            ps = con.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    params[i].set(log, ps, i + 1, args);
                }
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            log.error((Object)("Finder failed: " + e.getMessage()), (Throwable)e);
            FinderException fe = new FinderException(e.getMessage());
            fe.initCause((Throwable)e);
            throw fe;
        }
        Collection result = collectionStrategy.readResultSet(con, ps, rs, factory);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object fetchOne(JDBCEntityBridge2 entity, String sql, QueryParameter[] params, ResultReader resultReader, Object[] args, GenericEntityObjectFactory factory, Logger log) throws FinderException {
        Object pk;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean throwRuntimeExceptions = entity.getMetaData().getThrowRuntimeExceptions();
        if (throwRuntimeExceptions) {
            try {
                con = entity.getDataSource().getConnection();
            }
            catch (SQLException sqle) {
                EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
                throw ejbe;
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing: " + sql));
            }
            if (!throwRuntimeExceptions) {
                con = entity.getDataSource().getConnection();
            }
            ps = con.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    params[i].set(log, ps, i + 1, args);
                }
            }
            if (!(rs = ps.executeQuery()).next()) throw new ObjectNotFoundException();
            pk = resultReader.readRow(rs, factory);
            if (rs.next()) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(pk);
                list.add(resultReader.readRow(rs, factory));
                while (rs.next()) {
                    list.add(resultReader.readRow(rs, factory));
                }
                throw new FinderException("More than one instance matches the single-object finder criteria: " + list);
            }
        }
        catch (FinderException e) {
            try {
                throw e;
                catch (Exception e2) {
                    FinderException fe = new FinderException(e2.getMessage());
                    fe.initCause((Throwable)e2);
                    throw fe;
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        return pk;
    }

    protected void setParameters(List p) {
        if (p.size() > 0) {
            this.params = new QueryParameter[p.size()];
            for (int i = 0; i < p.size(); ++i) {
                Object pi = p.get(i);
                if (!(pi instanceof QueryParameter)) {
                    throw new IllegalArgumentException("Element " + i + " of list is not an instance of QueryParameter, but " + p.get(i).getClass().getName());
                }
                this.params[i] = (QueryParameter)pi;
            }
        }
    }

    static class EagerCollectionStrategy
    implements CollectionStrategy {
        private final CollectionFactory collectionFactory;
        private final ResultReader resultReader;
        private final Logger log;

        public EagerCollectionStrategy(CollectionFactory collectionFactory, ResultReader resultReader, Logger log) {
            this.collectionFactory = collectionFactory;
            this.resultReader = resultReader;
            this.log = log;
        }

        public Collection readResultSet(Connection con, PreparedStatement ps, ResultSet rs, GenericEntityObjectFactory factory) throws FinderException {
            Collection<Object> result;
            try {
                if (rs.next()) {
                    result = this.collectionFactory.newCollection();
                    Object instance = this.resultReader.readRow(rs, factory);
                    result.add(instance);
                    while (rs.next()) {
                        instance = this.resultReader.readRow(rs, factory);
                        result.add(instance);
                    }
                } else {
                    result = Collections.EMPTY_SET;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Finder failed: " + e.getMessage()), (Throwable)e);
                throw new FinderException(e.getMessage());
            }
            finally {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
            }
            return result;
        }
    }

    static interface CollectionStrategy {
        public Collection readResultSet(Connection var1, PreparedStatement var2, ResultSet var3, GenericEntityObjectFactory var4) throws FinderException;
    }

    static class FunctionReader
    implements ResultReader {
        private final SelectFunction function;

        public FunctionReader(SelectFunction function) {
            this.function = function;
        }

        public Object readRow(ResultSet rs, GenericEntityObjectFactory factory) throws SQLException {
            return this.function.readResult(rs);
        }
    }

    static class FieldReader
    implements ResultReader {
        private final JDBCCMPFieldBridge2 field;

        public FieldReader(JDBCCMPFieldBridge2 field) {
            this.field = field;
        }

        public Object readRow(ResultSet rs, GenericEntityObjectFactory factory) throws SQLException {
            return this.field.loadArgumentResults(rs, 1);
        }
    }

    static class EntityReader
    implements ResultReader {
        private final JDBCEntityBridge2 entity;

        public EntityReader(JDBCEntityBridge2 entity) {
            this.entity = entity;
        }

        public Object readRow(ResultSet rs, GenericEntityObjectFactory factory) {
            Object pk = this.entity.getTable().loadRow(rs);
            return pk == null ? null : factory.getEntityEJBObject(pk);
        }
    }

    static interface ResultReader {
        public Object readRow(ResultSet var1, GenericEntityObjectFactory var2) throws SQLException;
    }

    static interface CollectionFactory {
        public Collection newCollection();
    }
}

