/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;

public abstract class JDBCIdentityColumnCreateCommand
extends JDBCAbstractCreateCommand {
    protected JDBCCMPFieldBridge pkField;
    protected String pkSQL;

    protected boolean isInsertField(JDBCFieldBridge field) {
        return super.isInsertField(field) && !field.isPrimaryKeyMember();
    }

    protected void initGeneratedFields() throws DeploymentException {
        super.initGeneratedFields();
        this.pkField = this.getGeneratedPKField();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement s = null;
        ResultSet rs = null;
        try {
            Connection c = ps.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.pkSQL);
            if (!rs.next()) {
                throw new EJBException("ResultSet was empty");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException("Error extracting generated key", e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(s);
        return rows;
    }

    protected SQLException processException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof SQLException) {
            return (SQLException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        this.log.error((Object)t);
        throw new IllegalStateException();
    }
}

