/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.RelationData;
import org.jboss.ejb.plugins.cmp.jdbc.RelationPair;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.logging.Logger;

public final class JDBCDeleteRelationsCommand {
    private final Logger log;

    public JDBCDeleteRelationsCommand(JDBCStoreManager manager) {
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public void execute(RelationData relationData) {
        if (relationData.removedRelations.size() == 0) {
            return;
        }
        String sql = JDBCDeleteRelationsCommand.createSQL(relationData);
        Connection con = null;
        PreparedStatement ps = null;
        JDBCCMRFieldBridge cmrField = relationData.getLeftCMRField();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + sql));
            }
            DataSource dataSource = cmrField.getDataSource();
            con = dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JDBCDeleteRelationsCommand.setParameters(ps, relationData);
            int rowsAffected = ps.executeUpdate();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Rows affected = " + rowsAffected));
            }
        }
        catch (Exception e) {
            try {
                throw new EJBException("Could not delete relations from " + cmrField.getQualifiedTableName(), e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private static String createSQL(RelationData relationData) {
        JDBCCMRFieldBridge left = relationData.getLeftCMRField();
        JDBCCMRFieldBridge right = relationData.getRightCMRField();
        StringBuffer sql = new StringBuffer(300);
        sql.append("DELETE FROM ").append(left.getQualifiedTableName()).append(" WHERE ");
        int removedRelations = relationData.removedRelations.size();
        if (removedRelations > 0) {
            StringBuffer whereClause = new StringBuffer(20);
            whereClause.append('(');
            SQLUtil.getWhereClause(left.getTableKeyFields(), whereClause).append(" AND ");
            SQLUtil.getWhereClause(right.getTableKeyFields(), whereClause).append(')');
            String whereClauseStr = whereClause.toString();
            sql.append(whereClauseStr);
            for (int i = 1; i < removedRelations; ++i) {
                sql.append(" OR ").append(whereClauseStr);
            }
        }
        return sql.toString();
    }

    private static void setParameters(PreparedStatement ps, RelationData relationData) throws Exception {
        int index = 1;
        Iterator pairs = relationData.removedRelations.iterator();
        JDBCCMPFieldBridge[] leftFields = (JDBCCMPFieldBridge[])relationData.getLeftCMRField().getTableKeyFields();
        JDBCCMPFieldBridge[] rightFields = (JDBCCMPFieldBridge[])relationData.getRightCMRField().getTableKeyFields();
        while (pairs.hasNext()) {
            RelationPair pair = (RelationPair)pairs.next();
            Object leftId = pair.getLeftId();
            for (int i = 0; i < leftFields.length; ++i) {
                index = leftFields[i].setPrimaryKeyParameters(ps, index, leftId);
            }
            Object rightId = pair.getRightId();
            for (int i = 0; i < rightFields.length; ++i) {
                index = rightFields[i].setPrimaryKeyParameters(ps, index, rightId);
            }
        }
    }
}

