/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.transaction.Synchronization;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
import org.jboss.ejb.plugins.cmp.jdbc.AliasManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.ReadAheadCache;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCLeftJoinMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.logging.Logger;

public abstract class JDBCAbstractQueryCommand
implements JDBCQueryCommand {
    private JDBCQueryMetaData queryMetaData;
    protected Logger log;
    private JDBCStoreManager selectManager;
    private JDBCEntityBridge selectEntity;
    private JDBCCMPFieldBridge selectField;
    private SelectFunction selectFunction;
    private boolean[] eagerLoadMask;
    private String eagerLoadGroup;
    private String sql;
    private int offsetParam;
    private int offsetValue;
    private int limitParam;
    private int limitValue;
    private List parameters = new ArrayList(0);
    private List onFindCMRList = Collections.EMPTY_LIST;
    private QueryCollectionFactory collectionFactory;

    public JDBCAbstractQueryCommand(JDBCStoreManager manager, JDBCQueryMetaData q) {
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName() + "#" + q.getMethod().getName()));
        this.queryMetaData = q;
        this.collectionFactory = q.isLazyResultSetLoading() ? new LazyCollectionFactory() : new EagerCollectionFactory();
        this.setSelectEntity((JDBCEntityBridge)manager.getEntityBridge());
    }

    public void setOffsetValue(int offsetValue) {
        this.offsetValue = offsetValue;
    }

    public void setLimitValue(int limitValue) {
        this.limitValue = limitValue;
    }

    public void setOffsetParam(int offsetParam) {
        this.offsetParam = offsetParam;
    }

    public void setLimitParam(int limitParam) {
        this.limitParam = limitParam;
    }

    public void setOnFindCMRList(List onFindCMRList) {
        this.onFindCMRList = onFindCMRList;
    }

    public JDBCStoreManager getSelectManager() {
        return this.selectManager;
    }

    public Collection execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        int offset = JDBCAbstractQueryCommand.toInt(args, this.offsetParam, this.offsetValue);
        int limit = JDBCAbstractQueryCommand.toInt(args, this.limitParam, this.limitValue);
        return this.execute(this.sql, args, offset, limit, this.selectEntity, this.selectField, this.selectFunction, this.selectManager, this.eagerLoadMask, this.parameters, this.onFindCMRList, this.queryMetaData, factory, this.log);
    }

    protected static int toInt(Object[] params, int paramNumber, int defaultValue) {
        if (paramNumber == 0) {
            return defaultValue;
        }
        Integer arg = (Integer)params[paramNumber - 1];
        return arg;
    }

    protected Collection execute(String sql, Object[] args, int offset, int limit, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, List parameters, List onFindCMRList, JDBCQueryMetaData queryMetaData, GenericEntityObjectFactory factory, Logger log) throws FinderException {
        int count = offset;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCEntityBridge entityBridge = (JDBCEntityBridge)selectManager.getEntityBridge();
        boolean throwRuntimeExceptions = entityBridge.getMetaData().getThrowRuntimeExceptions();
        if (throwRuntimeExceptions) {
            try {
                con = entityBridge.getDataSource().getConnection();
            }
            catch (SQLException sqle) {
                EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
                ejbe.initCause((Throwable)sqle);
                throw ejbe;
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL: " + sql));
                if (limit != 0 || offset != 0) {
                    log.debug((Object)("Query offset=" + offset + ", limit=" + limit));
                }
            }
            if (!throwRuntimeExceptions) {
                con = entityBridge.getDataSource().getConnection();
            }
            ps = con.prepareStatement(sql);
            if (entityBridge.getFetchSize() > 0) {
                ps.setFetchSize(entityBridge.getFetchSize());
            }
            for (int i = 0; i < parameters.size(); ++i) {
                QueryParameter parameter = (QueryParameter)parameters.get(i);
                parameter.set(log, ps, i + 1, args);
            }
            rs = ps.executeQuery();
            while (count > 0 && rs.next()) {
                --count;
            }
            count = limit;
        }
        catch (Exception e) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            log.error((Object)"Find failed", (Throwable)e);
            FinderException fe = new FinderException("Find failed: " + e);
            fe.initCause((Throwable)e);
            throw fe;
        }
        return this.collectionFactory.createCollection(con, ps, rs, limit, count, selectEntity, selectField, selectFunction, selectManager, eagerLoadMask, factory);
    }

    protected Logger getLog() {
        return this.log;
    }

    protected void setSQL(String sql) {
        this.sql = sql;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("SQL: " + sql));
        }
    }

    protected void setParameterList(List p) {
        for (int i = 0; i < p.size(); ++i) {
            if (p.get(i) instanceof QueryParameter) continue;
            throw new IllegalArgumentException("Element " + i + " of list " + "is not an instance of QueryParameter, but " + p.get(i).getClass().getName());
        }
        this.parameters = new ArrayList(p);
    }

    protected JDBCEntityBridge getSelectEntity() {
        return this.selectEntity;
    }

    protected void setSelectEntity(JDBCEntityBridge selectEntity) {
        this.selectField = null;
        this.selectFunction = null;
        this.selectEntity = selectEntity;
        this.selectManager = (JDBCStoreManager)selectEntity.getManager();
    }

    protected JDBCCMPFieldBridge getSelectField() {
        return this.selectField;
    }

    protected void setSelectField(JDBCCMPFieldBridge selectField) {
        this.selectEntity = null;
        this.selectFunction = null;
        this.selectField = selectField;
        this.selectManager = (JDBCStoreManager)selectField.getManager();
    }

    protected void setSelectFunction(SelectFunction func, JDBCStoreManager manager) {
        this.selectEntity = null;
        this.selectField = null;
        this.selectFunction = func;
        this.selectManager = manager;
    }

    protected void setEagerLoadGroup(String eagerLoadGroup) {
        this.eagerLoadGroup = eagerLoadGroup;
        this.eagerLoadMask = this.selectEntity.getLoadGroupMask(eagerLoadGroup);
    }

    protected String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    protected boolean[] getEagerLoadMask() {
        return this.eagerLoadMask;
    }

    protected String parseParameters(String sql) throws DeploymentException {
        StringBuffer sqlBuf = new StringBuffer();
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        if (sql != null) {
            sql = sql.trim();
            StringTokenizer tokens = new StringTokenizer(sql, "{}", true);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals("{")) {
                    token = tokens.nextToken();
                    if (Character.isDigit(token.charAt(0))) {
                        QueryParameter parameter = new QueryParameter(this.selectManager, this.queryMetaData.getMethod(), token);
                        sqlBuf.append("?");
                        params.add(parameter);
                        if (tokens.nextToken().equals("}")) continue;
                        throw new DeploymentException("Invalid parameter - missing closing '}' : " + sql);
                    }
                    sqlBuf.append("{").append(token);
                    continue;
                }
                sqlBuf.append(token);
            }
        }
        this.parameters = params;
        return sqlBuf.toString();
    }

    public static List getLeftJoinCMRNodes(JDBCEntityBridge entity, String path, Iterator leftJoinIter) throws DeploymentException {
        ArrayList<LeftJoinCMRNode> leftJoinCMRNodes;
        if (leftJoinIter.hasNext()) {
            leftJoinCMRNodes = new ArrayList<LeftJoinCMRNode>();
            while (leftJoinIter.hasNext()) {
                JDBCLeftJoinMetaData leftJoin = (JDBCLeftJoinMetaData)leftJoinIter.next();
                JDBCCMRFieldBridge cmrField = entity.getCMRFieldByName(leftJoin.getCmrField());
                if (cmrField == null) {
                    throw new DeploymentException("cmr-field in left-join was not found: cmr-field=" + leftJoin.getCmrField() + ", entity=" + entity.getEntityName());
                }
                JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
                String childPath = path + '.' + cmrField.getFieldName();
                List subNodes = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(relatedEntity, childPath, leftJoin.getLeftJoins());
                boolean[] mask = relatedEntity.getLoadGroupMask(leftJoin.getEagerLoadGroup());
                LeftJoinCMRNode node = new LeftJoinCMRNode(childPath, cmrField, mask, subNodes);
                leftJoinCMRNodes.add(node);
            }
        } else {
            leftJoinCMRNodes = Collections.EMPTY_LIST;
        }
        return leftJoinCMRNodes;
    }

    public static final void leftJoinCMRNodes(String alias, List onFindCMRNodes, AliasManager aliasManager, StringBuffer sb) {
        for (int i = 0; i < onFindCMRNodes.size(); ++i) {
            LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(i);
            JDBCCMRFieldBridge cmrField = node.cmrField;
            JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
            String relatedAlias = aliasManager.getAlias(node.path);
            JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
            if (relation.isTableMappingStyle()) {
                String relTableAlias = aliasManager.getRelationTableAlias(node.path);
                sb.append(" LEFT OUTER JOIN ").append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField, alias, relTableAlias, sb);
                sb.append(" LEFT OUTER JOIN ").append(relatedEntity.getQualifiedTableName()).append(' ').append(relatedAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), relatedAlias, relTableAlias, sb);
            } else {
                sb.append(" LEFT OUTER JOIN ").append(relatedEntity.getQualifiedTableName()).append(' ').append(relatedAlias).append(" ON ");
                SQLUtil.getJoinClause(cmrField, alias, relatedAlias, sb);
            }
            List subNodes = node.onFindCMRNodes;
            if (subNodes.isEmpty()) continue;
            JDBCAbstractQueryCommand.leftJoinCMRNodes(relatedAlias, subNodes, aliasManager, sb);
        }
    }

    public static final void appendLeftJoinCMRColumnNames(List onFindCMRNodes, AliasManager aliasManager, StringBuffer sb) {
        for (int i = 0; i < onFindCMRNodes.size(); ++i) {
            List subNodes;
            LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(i);
            JDBCCMRFieldBridge cmrField = node.cmrField;
            JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
            String childAlias = aliasManager.getAlias(node.path);
            SQLUtil.appendColumnNamesClause(relatedEntity.getPrimaryKeyFields(), childAlias, sb);
            if (node.eagerLoadMask != null) {
                SQLUtil.appendColumnNamesClause(relatedEntity.getTableFields(), node.eagerLoadMask, childAlias, sb);
            }
            if ((subNodes = node.onFindCMRNodes).isEmpty()) continue;
            JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(subNodes, aliasManager, sb);
        }
    }

    private static int loadOnFindCMRFields(Object pk, List onFindCMRNodes, ResultSet rs, int index, Logger log) {
        Object[] ref = new Object[1];
        for (int nodeInd = 0; nodeInd < onFindCMRNodes.size(); ++nodeInd) {
            List subNodes;
            boolean cacheRelatedData;
            LeftJoinCMRNode node = (LeftJoinCMRNode)onFindCMRNodes.get(nodeInd);
            JDBCCMRFieldBridge cmrField = node.cmrField;
            ReadAheadCache myCache = cmrField.getJDBCStoreManager().getReadAheadCache();
            JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
            ReadAheadCache relatedCache = cmrField.getRelatedManager().getReadAheadCache();
            ref[0] = null;
            index = relatedEntity.loadPrimaryKeyResults(rs, index, ref);
            Object relatedId = ref[0];
            boolean bl = cacheRelatedData = relatedId != null;
            if (pk != null) {
                if (cmrField.getMetaData().getRelatedRole().isMultiplicityOne()) {
                    myCache.addPreloadData(pk, cmrField, relatedId == null ? Collections.EMPTY_LIST : Collections.singletonList(relatedId));
                } else {
                    ArrayList<Object> cachedValue = myCache.getCachedCMRValue(pk, cmrField);
                    if (cachedValue == null) {
                        cachedValue = new ArrayList<Object>();
                        myCache.addPreloadData(pk, cmrField, cachedValue);
                    }
                    if (relatedId != null) {
                        if (cachedValue.contains(relatedId)) {
                            cacheRelatedData = false;
                        } else {
                            cachedValue.add(relatedId);
                        }
                    }
                }
            }
            if (node.eagerLoadMask != null) {
                JDBCFieldBridge[] tableFields = relatedEntity.getTableFields();
                for (int fieldInd = 0; fieldInd < tableFields.length; ++fieldInd) {
                    if (!node.eagerLoadMask[fieldInd]) continue;
                    JDBCFieldBridge field = tableFields[fieldInd];
                    ref[0] = null;
                    index = field.loadArgumentResults(rs, index, ref);
                    if (!cacheRelatedData) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Caching " + relatedEntity.getEntityName() + '[' + relatedId + "]." + field.getFieldName() + "=" + ref[0]));
                    }
                    relatedCache.addPreloadData(relatedId, field, ref[0]);
                }
            }
            if ((subNodes = node.onFindCMRNodes).isEmpty()) continue;
            index = JDBCAbstractQueryCommand.loadOnFindCMRFields(relatedId, subNodes, rs, index, log);
        }
        return index;
    }

    class LazyCollectionFactory
    implements QueryCollectionFactory {
        LazyCollectionFactory() {
        }

        public Collection createCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, GenericEntityObjectFactory factory) throws FinderException {
            return new LazyCollection(con, ps, rs, limit, count, selectEntity, selectField, selectFunction, selectManager, eagerLoadMask, factory);
        }

        private class LazyCollection
        extends AbstractCollection {
            private final Connection con;
            private final PreparedStatement ps;
            private final ResultSet rs;
            private final int limit;
            private int count;
            private final JDBCEntityBridge selectEntity;
            private final JDBCCMPFieldBridge selectField;
            private final SelectFunction selectFunction;
            private final JDBCStoreManager selectManager;
            private final boolean[] eagerLoadMask;
            private final GenericEntityObjectFactory factory;
            private Object prevPk;
            private Object curPk;
            private Object currentResult;
            Object[] ref = new Object[1];
            boolean loadOnFindCmr;
            private List results = null;
            private Iterator firstIterator;
            private int size;
            private boolean resourcesClosed;

            public LazyCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, GenericEntityObjectFactory factory) {
                this.con = con;
                this.ps = ps;
                this.rs = rs;
                this.limit = limit;
                this.count = count;
                this.selectEntity = selectEntity;
                this.selectField = selectField;
                this.selectFunction = selectFunction;
                this.selectManager = selectManager;
                this.eagerLoadMask = eagerLoadMask;
                this.factory = factory;
                this.loadOnFindCmr = !JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty();
                this.firstIterator = this.getFirstIterator();
                if (this.firstIterator.hasNext()) {
                    try {
                        this.size = rs.getInt(1);
                    }
                    catch (SQLException e) {
                        throw new EJBException("Failed to read ResultSet.", (Exception)e);
                    }
                    if (limit > 0 && this.size > limit) {
                        this.size = limit;
                    }
                }
                if (this.size < 1) {
                    this.firstIterator = null;
                    this.results = new ArrayList(0);
                    this.closeResources();
                } else {
                    this.results = new ArrayList(this.size);
                    try {
                        selectManager.getContainer().getTransactionManager().getTransaction().registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                                LazyCollection.this.closeResources();
                            }

                            public void afterCompletion(int status) {
                                LazyCollection.this.closeResources();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new EJBException("Failed to obtain current transaction", e);
                    }
                }
            }

            private void closeResources() {
                if (!this.resourcesClosed) {
                    JDBCUtil.safeClose(this.rs);
                    JDBCUtil.safeClose(this.ps);
                    JDBCUtil.safeClose(this.con);
                    this.resourcesClosed = true;
                }
            }

            public Iterator iterator() {
                return this.firstIterator != null ? this.firstIterator : this.results.iterator();
            }

            public int size() {
                return this.firstIterator != null ? this.size : this.results.size();
            }

            public boolean add(Object o) {
                if (this.firstIterator == null) {
                    return this.results.add(o);
                }
                throw new IllegalStateException("Can't modify collection while the first iterator is not exhausted.");
            }

            public boolean remove(Object o) {
                if (this.firstIterator == null) {
                    return this.results.remove(o);
                }
                throw new IllegalStateException("Can't modify collection while the first iterator is not exhausted.");
            }

            private boolean hasNextResult() {
                try {
                    boolean has;
                    boolean bl = has = (this.limit == 0 || this.count-- > 0) && this.rs.next();
                    if (!has) {
                        if (JDBCAbstractQueryCommand.this.log.isTraceEnabled()) {
                            JDBCAbstractQueryCommand.this.log.trace((Object)"first iterator exhausted!");
                        }
                        this.firstIterator = null;
                        this.closeResources();
                    }
                    return has;
                }
                catch (Exception e) {
                    JDBCAbstractQueryCommand.this.log.error((Object)"Failed to read ResultSet.", (Throwable)e);
                    throw new EJBException("Failed to read ResultSet: " + e.getMessage());
                }
            }

            private Object readNext() {
                try {
                    if (this.selectEntity != null) {
                        boolean addPk;
                        ReadAheadCache selectReadAheadCache = this.selectManager.getReadAheadCache();
                        int index = 2;
                        index = this.selectEntity.loadPrimaryKeyResults(this.rs, index, this.ref);
                        this.curPk = this.ref[0];
                        boolean bl = this.loadOnFindCmr ? !this.curPk.equals(this.prevPk) : (addPk = true);
                        if (addPk) {
                            this.prevPk = this.curPk;
                            this.currentResult = this.factory.getEntityEJBObject(this.curPk);
                        }
                        if (this.eagerLoadMask != null) {
                            JDBCFieldBridge[] tableFields = this.selectEntity.getTableFields();
                            for (int i = 0; i < this.eagerLoadMask.length; ++i) {
                                if (!this.eagerLoadMask[i]) continue;
                                JDBCFieldBridge field = tableFields[i];
                                this.ref[0] = null;
                                index = field.loadArgumentResults(this.rs, index, this.ref);
                                if (!addPk) continue;
                                selectReadAheadCache.addPreloadData(this.curPk, field, this.ref[0]);
                            }
                            if (!JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty()) {
                                int n = JDBCAbstractQueryCommand.loadOnFindCMRFields(this.curPk, JDBCAbstractQueryCommand.this.onFindCMRList, this.rs, index, JDBCAbstractQueryCommand.this.log);
                            }
                        }
                    } else if (this.selectField != null) {
                        this.selectField.loadArgumentResults(this.rs, 2, this.ref);
                        this.currentResult = this.ref[0];
                    } else {
                        this.currentResult = this.selectFunction.readResult(this.rs);
                    }
                    if (JDBCAbstractQueryCommand.this.log.isTraceEnabled() && this.limit != 0 && this.count == 0) {
                        JDBCAbstractQueryCommand.this.log.trace((Object)("Query result was limited to " + this.limit + " row(s)"));
                    }
                    return this.currentResult;
                }
                catch (Exception e) {
                    JDBCAbstractQueryCommand.this.log.error((Object)"Failed to read ResultSet", (Throwable)e);
                    throw new EJBException("Failed to read ResultSet: " + e.getMessage());
                }
            }

            private Iterator getFirstIterator() {
                return new Iterator(){
                    private boolean hasNext;
                    private Object cursor;

                    public boolean hasNext() {
                        return this.hasNext ? this.hasNext : (this.hasNext = LazyCollection.this.hasNextResult());
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.hasNext = false;
                        this.cursor = LazyCollection.this.readNext();
                        LazyCollection.this.results.add(this.cursor);
                        return this.cursor;
                    }

                    public void remove() {
                        --LazyCollection.this.size;
                        LazyCollection.this.results.remove(this.cursor);
                    }
                };
            }
        }
    }

    class EagerCollectionFactory
    implements QueryCollectionFactory {
        EagerCollectionFactory() {
        }

        public Collection createCollection(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, JDBCEntityBridge selectEntity, JDBCCMPFieldBridge selectField, SelectFunction selectFunction, JDBCStoreManager selectManager, boolean[] eagerLoadMask, GenericEntityObjectFactory factory) throws FinderException {
            try {
                ArrayList<Object> results = new ArrayList<Object>();
                if (selectEntity != null) {
                    ReadAheadCache selectReadAheadCache = selectManager.getReadAheadCache();
                    ArrayList<Object> ids = new ArrayList<Object>();
                    boolean loadOnFindCmr = !JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty();
                    Object[] ref = new Object[1];
                    Object prevPk = null;
                    while ((limit == 0 || count-- > 0) && rs.next()) {
                        boolean addPk;
                        int index = 1;
                        index = selectEntity.loadPrimaryKeyResults(rs, index, ref);
                        Object pk = ref[0];
                        boolean bl = loadOnFindCmr ? !pk.equals(prevPk) : (addPk = true);
                        if (addPk) {
                            ids.add(pk);
                            results.add(factory.getEntityEJBObject(pk));
                            prevPk = pk;
                        }
                        if (eagerLoadMask == null) continue;
                        JDBCFieldBridge[] tableFields = selectEntity.getTableFields();
                        for (int i = 0; i < eagerLoadMask.length; ++i) {
                            if (!eagerLoadMask[i]) continue;
                            JDBCFieldBridge field = tableFields[i];
                            ref[0] = null;
                            index = field.loadArgumentResults(rs, index, ref);
                            if (!addPk) continue;
                            selectReadAheadCache.addPreloadData(pk, field, ref[0]);
                        }
                        if (JDBCAbstractQueryCommand.this.onFindCMRList.isEmpty()) continue;
                        index = JDBCAbstractQueryCommand.loadOnFindCMRFields(pk, JDBCAbstractQueryCommand.this.onFindCMRList, rs, index, JDBCAbstractQueryCommand.this.log);
                    }
                    selectReadAheadCache.addFinderResults(ids, JDBCAbstractQueryCommand.this.queryMetaData.getReadAhead());
                } else if (selectField != null) {
                    Object[] valueRef = new Object[1];
                    while ((limit == 0 || count-- > 0) && rs.next()) {
                        valueRef[0] = null;
                        selectField.loadArgumentResults(rs, 1, valueRef);
                        results.add(valueRef[0]);
                    }
                } else {
                    while (rs.next()) {
                        results.add(selectFunction.readResult(rs));
                    }
                }
                if (JDBCAbstractQueryCommand.this.log.isDebugEnabled() && limit != 0 && count == 0) {
                    JDBCAbstractQueryCommand.this.log.debug((Object)("Query result was limited to " + limit + " row(s)"));
                }
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            catch (Exception e) {
                JDBCAbstractQueryCommand.this.log.error((Object)"Find failed", (Throwable)e);
                throw new FinderException("Find failed: " + e);
            }
            finally {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
            }
        }
    }

    static interface QueryCollectionFactory {
        public Collection createCollection(Connection var1, PreparedStatement var2, ResultSet var3, int var4, int var5, JDBCEntityBridge var6, JDBCCMPFieldBridge var7, SelectFunction var8, JDBCStoreManager var9, boolean[] var10, GenericEntityObjectFactory var11) throws FinderException;
    }

    public static final class LeftJoinCMRNode {
        public final String path;
        public final JDBCCMRFieldBridge cmrField;
        public final boolean[] eagerLoadMask;
        public final List onFindCMRNodes;

        public LeftJoinCMRNode(String path, JDBCCMRFieldBridge cmrField, boolean[] eagerLoadMask, List onFindCMRNodes) {
            this.path = path;
            this.cmrField = cmrField;
            this.eagerLoadMask = eagerLoadMask;
            this.onFindCMRNodes = onFindCMRNodes;
        }

        public boolean equals(Object o) {
            boolean result;
            if (o == this) {
                result = true;
            } else if (o instanceof LeftJoinCMRNode) {
                LeftJoinCMRNode other = (LeftJoinCMRNode)o;
                result = this.cmrField == other.cmrField;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.cmrField == null ? Integer.MIN_VALUE : this.cmrField.hashCode();
        }

        public String toString() {
            return '[' + this.cmrField.getFieldName() + ": " + this.onFindCMRNodes + ']';
        }
    }
}

