/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.Serializable;
import org.jboss.cache.invalidation.Invalidatable;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.ejb.plugins.EntityInstanceCache;
import org.jboss.metadata.EntityMetaData;
import org.jboss.system.Registry;

public class InvalidableEntityInstanceCache
extends EntityInstanceCache
implements Invalidatable {
    protected InvalidationManagerMBean invalMgr = null;
    protected InvalidationGroup ig = null;
    protected boolean isTraceEnabled = false;

    public void areInvalid(Serializable[] keys) {
        if (this.isTraceEnabled) {
            log.trace((Object)("Invalidating entry in cache. Quantity: " + keys.length));
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                this.doInvalidate(keys[i]);
                continue;
            }
            catch (Exception ignored) {
                log.debug((Object)ignored);
            }
        }
    }

    public void isInvalid(Serializable key) {
        try {
            this.doInvalidate(key);
        }
        catch (Exception ignored) {
            log.debug((Object)ignored);
        }
    }

    public void invalidateAll() {
        this.flush();
    }

    public void start() throws Exception {
        super.start();
        log.debug((Object)"Starting InvalidableEntityInstanceCache...");
        EntityMetaData emd = (EntityMetaData)this.getContainer().getBeanMetaData();
        boolean participateInDistInvalidations = emd.doDistributedCacheInvalidations();
        byte co = emd.getContainerConfiguration().getCommitOption();
        if (participateInDistInvalidations && (co == 0 || co == 3)) {
            String groupName = emd.getDistributedCacheInvalidationConfig().getInvalidationGroupName();
            String imName = emd.getDistributedCacheInvalidationConfig().getInvalidationManagerName();
            this.invalMgr = (InvalidationManagerMBean)Registry.lookup((Object)imName);
            this.ig = this.invalMgr.getInvalidationGroup(groupName);
            this.ig.register(this);
            this.isTraceEnabled = log.isTraceEnabled();
        }
    }

    public void stop() {
        try {
            this.ig.unregister(this);
            this.ig = null;
            this.invalMgr = null;
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        super.stop();
    }

    protected void doInvalidate(Serializable key) {
        if (key != null) {
            this.remove(key);
        }
    }
}

