/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.plugins.spi.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.logging.Logger;

public class KernelControllerContextActions
extends AbstractControllerContextActions {
    private static KernelControllerContextActions instance;
    private static KernelControllerContextActions noInstantiate;

    protected static Object dispatchJoinPoint(KernelControllerContext context, Joinpoint joinpoint) throws Throwable {
        AccessControlContext access = null;
        if (context instanceof AbstractKernelControllerContext) {
            AbstractKernelControllerContext theContext = (AbstractKernelControllerContext)context;
            access = theContext.getAccessControlContext();
        }
        if (access == null) {
            return joinpoint.dispatch();
        }
        DispatchJoinPoint action = new DispatchJoinPoint(joinpoint);
        try {
            return AccessController.doPrivileged(action, access);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public static KernelControllerContextActions getInstance() {
        if (instance == null) {
            HashMap<ControllerState, KernelControllerContextAction> actions = new HashMap<ControllerState, KernelControllerContextAction>();
            actions.put(ControllerState.DESCRIBED, new DescribeAction());
            actions.put(ControllerState.INSTANTIATED, new InstantiateAction());
            actions.put(ControllerState.CONFIGURED, new ConfigureAction());
            actions.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
            actions.put(ControllerState.START, new StartStopLifecycleAction());
            actions.put(ControllerState.INSTALLED, new InstallAction());
            instance = new KernelControllerContextActions(actions);
        }
        return instance;
    }

    public static KernelControllerContextActions getNoInstantiate() {
        if (noInstantiate == null) {
            HashMap<ControllerState, KernelControllerContextAction> actions = new HashMap<ControllerState, KernelControllerContextAction>();
            actions.put(ControllerState.DESCRIBED, new DescribeAction());
            actions.put(ControllerState.CONFIGURED, new ConfigureAction());
            actions.put(ControllerState.CREATE, new CreateDestroyLifecycleAction());
            actions.put(ControllerState.START, new StartStopLifecycleAction());
            actions.put(ControllerState.INSTALLED, new InstallAction());
            noInstantiate = new KernelControllerContextActions(actions);
        }
        return noInstantiate;
    }

    protected KernelControllerContextActions(Map actions) {
        super(actions);
    }

    private static class DispatchJoinPoint
    implements PrivilegedExceptionAction {
        private Joinpoint joinpoint;

        public DispatchJoinPoint(Joinpoint joinpoint) {
            this.joinpoint = joinpoint;
        }

        public Object run() throws Exception {
            try {
                return this.joinpoint.dispatch();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static class InstallAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext context) throws Throwable {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelRegistry registry = kernel.getRegistry();
            BeanMetaData metaData = context.getBeanMetaData();
            String name = metaData.getName();
            registry.registerEntry(name, context);
            controller.addSupplies(context);
            List installs = metaData.getInstalls();
            if (installs != null) {
                for (int i = 0; i < installs.size(); ++i) {
                    InstallMetaData install = (InstallMetaData)installs.get(i);
                    KernelControllerContext target = context;
                    if (install.getBean() != null) {
                        target = (KernelControllerContext)controller.getContext(install.getBean(), install.getDependentState());
                    }
                    this.dispatch(target, install.getMethodName(), install.getParameters());
                }
            }
        }

        public void uninstallAction(KernelControllerContext context) {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelRegistry registry = kernel.getRegistry();
            BeanMetaData metaData = context.getBeanMetaData();
            String name = metaData.getName();
            List uninstalls = metaData.getUninstalls();
            if (uninstalls != null) {
                for (int i = uninstalls.size() - 1; i >= 0; --i) {
                    InstallMetaData uninstall = (InstallMetaData)uninstalls.get(i);
                    KernelControllerContext target = context;
                    if (uninstall.getBean() != null && (target = (KernelControllerContext)controller.getContext(uninstall.getBean(), uninstall.getDependentState())) == null) {
                        this.log.warn((Object)("Ignoring uninstall action on target in incorrect state " + uninstall.getBean()));
                        continue;
                    }
                    try {
                        this.dispatch(target, uninstall.getMethodName(), uninstall.getParameters());
                        continue;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Ignoring uninstall action on target " + uninstall), t);
                    }
                }
            }
            try {
                controller.removeSupplies(context);
                registry.unregisterEntry(name);
            }
            catch (Throwable t) {
                this.log.warn((Object)("Ignoring unregistered entry at uninstall " + name));
            }
        }

        protected void dispatch(KernelControllerContext context, String method, List parameters) throws Throwable {
            KernelController controller = (KernelController)context.getController();
            KernelConfigurator configurator = controller.getKernel().getConfigurator();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            ClassLoader cl = Configurator.getClassLoader(metaData);
            MethodJoinpoint joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            joinpoint.setTarget(context.getTarget());
            KernelControllerContextActions.dispatchJoinPoint(context, (Joinpoint)joinpoint);
        }
    }

    public static class StartStopLifecycleAction
    extends LifecycleAction {
        public String getInstallMethod(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getStart();
            if (lifecycle != null) {
                return lifecycle.getMethodName();
            }
            return "start";
        }

        public List getInstallParameters(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getStart();
            if (lifecycle != null) {
                return lifecycle.getParameters();
            }
            return null;
        }

        public String getUninstallMethod(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getStop();
            if (lifecycle != null) {
                return lifecycle.getMethodName();
            }
            return "stop";
        }

        public List getUninstallParameters(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getStop();
            if (lifecycle != null) {
                return lifecycle.getParameters();
            }
            return null;
        }
    }

    public static class CreateDestroyLifecycleAction
    extends LifecycleAction {
        public String getInstallMethod(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getCreate();
            if (lifecycle != null) {
                return lifecycle.getMethodName();
            }
            return "create";
        }

        public List getInstallParameters(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getCreate();
            if (lifecycle != null) {
                return lifecycle.getParameters();
            }
            return null;
        }

        public String getUninstallMethod(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getDestroy();
            if (lifecycle != null) {
                return lifecycle.getMethodName();
            }
            return "destroy";
        }

        public List getUninstallParameters(KernelControllerContext context) {
            BeanMetaData metaData = context.getBeanMetaData();
            LifecycleMetaData lifecycle = metaData.getDestroy();
            if (lifecycle != null) {
                return lifecycle.getParameters();
            }
            return null;
        }
    }

    public static abstract class LifecycleAction
    extends KernelControllerContextAction {
        public abstract String getInstallMethod(KernelControllerContext var1);

        public abstract List getInstallParameters(KernelControllerContext var1);

        public abstract String getUninstallMethod(KernelControllerContext var1);

        public abstract List getUninstallParameters(KernelControllerContext var1);

        public void installAction(KernelControllerContext context) throws Throwable {
            boolean trace = this.log.isTraceEnabled();
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            Object target = context.getTarget();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            String method = this.getInstallMethod(context);
            List parameters = this.getInstallParameters(context);
            MethodJoinpoint joinpoint = null;
            try {
                ClassLoader cl = Configurator.getClassLoader(metaData);
                joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            }
            catch (JoinpointException ignored) {
                if (trace) {
                    if (parameters == null) {
                        this.log.trace((Object)("No " + method + " method for " + context));
                    } else {
                        this.log.trace((Object)("No " + method + parameters + " method for " + context));
                    }
                }
                return;
            }
            joinpoint.setTarget(target);
            KernelControllerContextActions.dispatchJoinPoint(context, (Joinpoint)joinpoint);
        }

        public void uninstallAction(KernelControllerContext context) {
            boolean trace = this.log.isTraceEnabled();
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            Object target = context.getTarget();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            String method = this.getUninstallMethod(context);
            List parameters = this.getUninstallParameters(context);
            MethodJoinpoint joinpoint = null;
            try {
                ClassLoader cl = Configurator.getClassLoader(metaData);
                joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
                joinpoint.setTarget(target);
                KernelControllerContextActions.dispatchJoinPoint(context, (Joinpoint)joinpoint);
            }
            catch (JoinpointException ignored) {
                if (trace) {
                    if (parameters == null) {
                        this.log.trace((Object)("No " + method + " method for " + context));
                    } else {
                        this.log.trace((Object)("No " + method + parameters + " method for " + context));
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("Error during " + method), throwable);
            }
        }
    }

    public static class ConfigureAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext context) throws Throwable {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            Object object = context.getTarget();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            Set joinPoints = configurator.getPropertySetterJoinPoints(info, metaData);
            this.setAttributes(context, object, joinPoints, false);
        }

        public void uninstallAction(KernelControllerContext context) {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            Object object = context.getTarget();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            try {
                Set joinPoints = configurator.getPropertyNullerJoinPoints(info, metaData);
                this.setAttributes(context, object, joinPoints, true);
            }
            catch (Throwable t) {
                this.log.warn((Object)("Error unconfiguring bean " + context), t);
            }
        }

        protected void setAttributes(KernelControllerContext context, Object target, Set joinPoints, boolean ignoreErrors) throws Throwable {
            if (!joinPoints.isEmpty()) {
                boolean trace = this.log.isTraceEnabled();
                Iterator i = joinPoints.iterator();
                while (i.hasNext()) {
                    TargettedJoinpoint joinPoint = (TargettedJoinpoint)i.next();
                    joinPoint.setTarget(target);
                    try {
                        KernelControllerContextActions.dispatchJoinPoint(context, (Joinpoint)joinPoint);
                    }
                    catch (Throwable t) {
                        if (ignoreErrors) {
                            if (!trace) continue;
                            this.log.trace((Object)("Ignored for " + joinPoint), t);
                            continue;
                        }
                        throw t;
                    }
                }
            }
        }
    }

    public static class InstantiateAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext context) throws Throwable {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            BeanMetaData metaData = context.getBeanMetaData();
            BeanInfo info = context.getBeanInfo();
            Joinpoint joinPoint = configurator.getConstructorJoinPoint(info, metaData.getConstructor(), metaData);
            Object object = KernelControllerContextActions.dispatchJoinPoint(context, joinPoint);
            context.setTarget(object);
            try {
                if (object != null && object instanceof KernelControllerContextAware) {
                    ((KernelControllerContextAware)object).setKernelControllerContext(context);
                }
            }
            catch (Throwable t) {
                this.uninstall(context);
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uninstallAction(KernelControllerContext context) {
            try {
                Object object = context.getTarget();
                if (object != null && object instanceof KernelControllerContextAware) {
                    ((KernelControllerContextAware)object).unsetKernelControllerContext(context);
                }
            }
            catch (Throwable ignored) {
                this.log.debug((Object)"Ignored error unsetting context ", ignored);
            }
            finally {
                context.setTarget(null);
            }
        }
    }

    public static class DescribeAction
    extends KernelControllerContextAction {
        public void installAction(KernelControllerContext context) throws Throwable {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            BeanMetaData metaData = context.getBeanMetaData();
            BeanInfo info = configurator.getBeanInfo(metaData);
            context.setBeanInfo(info);
            DependencyInfo depends = context.getDependencyInfo();
            List dependencies = info.getDependencies();
            if (dependencies != null) {
                Iterator it = dependencies.iterator();
                while (it.hasNext()) {
                    AbstractDependencyItem dependency = new AbstractDependencyItem((Object)metaData.getName(), it.next(), ControllerState.INSTANTIATED, ControllerState.INSTALLED);
                    depends.addIDependOn((DependencyItem)dependency);
                }
            }
        }

        public void uninstallAction(KernelControllerContext context) {
            context.setBeanInfo(null);
        }
    }

    public static class KernelControllerContextAction
    implements ControllerContextAction {
        protected Logger log = Logger.getLogger(this.getClass());

        public void install(final ControllerContext context) throws Throwable {
            if (System.getSecurityManager() == null || !(context instanceof AbstractKernelControllerContext)) {
                this.installAction((KernelControllerContext)context);
            } else {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            KernelControllerContextAction.this.installAction((KernelControllerContext)context);
                            return null;
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                };
                try {
                    AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    throw e.getCause();
                }
            }
        }

        public void uninstall(final ControllerContext context) {
            if (System.getSecurityManager() == null || !(context instanceof AbstractKernelControllerContext)) {
                this.uninstallAction((KernelControllerContext)context);
            } else {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        KernelControllerContextAction.this.uninstallAction((KernelControllerContext)context);
                        return null;
                    }
                };
                AccessController.doPrivileged(action);
            }
        }

        public void installAction(KernelControllerContext context) throws Throwable {
        }

        public void uninstallAction(KernelControllerContext context) {
        }
    }
}

