/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.group.ValueListInitializer;

public class ValueList {
    private final ValueListInitializer initializer;
    private final ValueListHandler handler;
    private final Class targetClass;
    private final int requiredTotal;
    private final Object[] requiredValues;
    private int state;
    private Map nonRequiredValues = Collections.EMPTY_MAP;
    private List nonRequiredBindings;

    ValueList(ValueListInitializer initializer, ValueListHandler handler, Class targetClass) {
        this.initializer = initializer;
        this.handler = handler;
        this.targetClass = targetClass;
        this.requiredTotal = initializer.getRequiredBindings().size();
        this.requiredValues = new Object[this.requiredTotal];
    }

    void setRequiredValue(int index, int stateIncrement, Object value) {
        if (index >= this.requiredTotal) {
            throw new JBossXBRuntimeException("Maximum argument index for this value list is " + this.requiredTotal + " but got " + index);
        }
        this.requiredValues[index] = value;
        this.state += stateIncrement;
    }

    Object getRequiredValue(int index) {
        if (index >= this.requiredTotal) {
            throw new JBossXBRuntimeException("Maximum argument index for this value list is " + this.requiredTotal + " but got " + index);
        }
        return this.requiredValues[index];
    }

    int getState() {
        return this.state;
    }

    void setNonRequiredValue(QName qName, Object binding, Object value) {
        switch (this.nonRequiredValues.size()) {
            case 0: {
                this.nonRequiredValues = Collections.singletonMap(qName, value);
                this.nonRequiredBindings = new ArrayList();
                this.nonRequiredBindings.add(binding);
                break;
            }
            case 1: {
                this.nonRequiredValues = new LinkedHashMap(this.nonRequiredValues);
            }
            default: {
                this.nonRequiredValues.put(qName, value);
                this.nonRequiredBindings.add(binding);
            }
        }
    }

    Object getNonRequiredValue(QName qName) {
        return this.nonRequiredValues.get(qName);
    }

    public ValueListInitializer getInitializer() {
        return this.initializer;
    }

    public List getRequiredValues() {
        return Arrays.asList(this.requiredValues);
    }

    public Map getNonRequiredValues() {
        return this.nonRequiredValues;
    }

    public List getNonRequiredBindings() {
        return this.nonRequiredBindings;
    }

    public ValueListHandler getHandler() {
        return this.handler;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }
}

